// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information for a custom model.
 */
public class CustomModelSummary private constructor(builder: Builder) {
    /**
     * The base model Amazon Resource Name (ARN).
     */
    public val baseModelArn: kotlin.String = requireNotNull(builder.baseModelArn) { "A non-null value must be provided for baseModelArn" }
    /**
     * The base model name.
     */
    public val baseModelName: kotlin.String = requireNotNull(builder.baseModelName) { "A non-null value must be provided for baseModelName" }
    /**
     * Creation time of the model.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html).
     */
    public val customizationType: aws.sdk.kotlin.services.bedrock.model.CustomizationType? = builder.customizationType
    /**
     * The Amazon Resource Name (ARN) of the custom model.
     */
    public val modelArn: kotlin.String = requireNotNull(builder.modelArn) { "A non-null value must be provided for modelArn" }
    /**
     * The name of the custom model.
     */
    public val modelName: kotlin.String = requireNotNull(builder.modelName) { "A non-null value must be provided for modelName" }
    /**
     * The unique identifier of the account that owns the model.
     */
    public val ownerAccountId: kotlin.String? = builder.ownerAccountId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.CustomModelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomModelSummary(")
        append("baseModelArn=$baseModelArn,")
        append("baseModelName=$baseModelName,")
        append("creationTime=$creationTime,")
        append("customizationType=$customizationType,")
        append("modelArn=$modelArn,")
        append("modelName=$modelName,")
        append("ownerAccountId=$ownerAccountId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseModelArn.hashCode()
        result = 31 * result + (baseModelName.hashCode())
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (customizationType?.hashCode() ?: 0)
        result = 31 * result + (modelArn.hashCode())
        result = 31 * result + (modelName.hashCode())
        result = 31 * result + (ownerAccountId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomModelSummary

        if (baseModelArn != other.baseModelArn) return false
        if (baseModelName != other.baseModelName) return false
        if (creationTime != other.creationTime) return false
        if (customizationType != other.customizationType) return false
        if (modelArn != other.modelArn) return false
        if (modelName != other.modelName) return false
        if (ownerAccountId != other.ownerAccountId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.CustomModelSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The base model Amazon Resource Name (ARN).
         */
        public var baseModelArn: kotlin.String? = null
        /**
         * The base model name.
         */
        public var baseModelName: kotlin.String? = null
        /**
         * Creation time of the model.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html).
         */
        public var customizationType: aws.sdk.kotlin.services.bedrock.model.CustomizationType? = null
        /**
         * The Amazon Resource Name (ARN) of the custom model.
         */
        public var modelArn: kotlin.String? = null
        /**
         * The name of the custom model.
         */
        public var modelName: kotlin.String? = null
        /**
         * The unique identifier of the account that owns the model.
         */
        public var ownerAccountId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.CustomModelSummary) : this() {
            this.baseModelArn = x.baseModelArn
            this.baseModelName = x.baseModelName
            this.creationTime = x.creationTime
            this.customizationType = x.customizationType
            this.modelArn = x.modelArn
            this.modelName = x.modelName
            this.ownerAccountId = x.ownerAccountId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.CustomModelSummary = CustomModelSummary(this)

        internal fun correctErrors(): Builder {
            if (baseModelArn == null) baseModelArn = ""
            if (baseModelName == null) baseModelName = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (modelArn == null) modelArn = ""
            if (modelName == null) modelName = ""
            return this
        }
    }
}
