// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateProvisionedModelThroughputRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the Amazon S3 User Guide.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The commitment duration requested for the Provisioned Throughput. Billing occurs hourly and is discounted for longer commitment terms. To request a no-commit Provisioned Throughput, omit this field.
     *
     * Custom models support all levels of commitment. To see which base models support no commitment, see [Supported regions and models for Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/pt-supported.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
     */
    public val commitmentDuration: aws.sdk.kotlin.services.bedrock.model.CommitmentDuration? = builder.commitmentDuration
    /**
     * The Amazon Resource Name (ARN) or name of the model to associate with this Provisioned Throughput. For a list of models for which you can purchase Provisioned Throughput, see [Amazon Bedrock model IDs for purchasing Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#prov-throughput-models) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public val modelId: kotlin.String? = builder.modelId
    /**
     * Number of model units to allocate. A model unit delivers a specific throughput level for the specified model. The throughput level of a model unit specifies the total number of input and output tokens that it can process and generate within a span of one minute. By default, your account has no model units for purchasing Provisioned Throughputs with commitment. You must first visit the [Amazon Web Services support center](https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase) to request MUs.
     *
     * For model unit quotas, see [Provisioned Throughput quotas](https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html#prov-thru-quotas) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     *
     * For more information about what an MU specifies, contact your Amazon Web Services account manager.
     */
    public val modelUnits: kotlin.Int? = builder.modelUnits
    /**
     * The name for this Provisioned Throughput.
     */
    public val provisionedModelName: kotlin.String? = builder.provisionedModelName
    /**
     * Tags to associate with this Provisioned Throughput.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.CreateProvisionedModelThroughputRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProvisionedModelThroughputRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("commitmentDuration=$commitmentDuration,")
        append("modelId=$modelId,")
        append("modelUnits=$modelUnits,")
        append("provisionedModelName=$provisionedModelName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (commitmentDuration?.hashCode() ?: 0)
        result = 31 * result + (modelId?.hashCode() ?: 0)
        result = 31 * result + (modelUnits ?: 0)
        result = 31 * result + (provisionedModelName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProvisionedModelThroughputRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (commitmentDuration != other.commitmentDuration) return false
        if (modelId != other.modelId) return false
        if (modelUnits != other.modelUnits) return false
        if (provisionedModelName != other.provisionedModelName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.CreateProvisionedModelThroughputRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the Amazon S3 User Guide.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The commitment duration requested for the Provisioned Throughput. Billing occurs hourly and is discounted for longer commitment terms. To request a no-commit Provisioned Throughput, omit this field.
         *
         * Custom models support all levels of commitment. To see which base models support no commitment, see [Supported regions and models for Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/pt-supported.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
         */
        public var commitmentDuration: aws.sdk.kotlin.services.bedrock.model.CommitmentDuration? = null
        /**
         * The Amazon Resource Name (ARN) or name of the model to associate with this Provisioned Throughput. For a list of models for which you can purchase Provisioned Throughput, see [Amazon Bedrock model IDs for purchasing Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#prov-throughput-models) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
         */
        public var modelId: kotlin.String? = null
        /**
         * Number of model units to allocate. A model unit delivers a specific throughput level for the specified model. The throughput level of a model unit specifies the total number of input and output tokens that it can process and generate within a span of one minute. By default, your account has no model units for purchasing Provisioned Throughputs with commitment. You must first visit the [Amazon Web Services support center](https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase) to request MUs.
         *
         * For model unit quotas, see [Provisioned Throughput quotas](https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html#prov-thru-quotas) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
         *
         * For more information about what an MU specifies, contact your Amazon Web Services account manager.
         */
        public var modelUnits: kotlin.Int? = null
        /**
         * The name for this Provisioned Throughput.
         */
        public var provisionedModelName: kotlin.String? = null
        /**
         * Tags to associate with this Provisioned Throughput.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.CreateProvisionedModelThroughputRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.commitmentDuration = x.commitmentDuration
            this.modelId = x.modelId
            this.modelUnits = x.modelUnits
            this.provisionedModelName = x.provisionedModelName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.CreateProvisionedModelThroughputRequest = CreateProvisionedModelThroughputRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
