// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateModelInvocationJobRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Details about the location of the input to the batch inference job.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobInputDataConfig? = builder.inputDataConfig
    /**
     * A name to give the batch inference job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The unique identifier of the foundation model to use for the batch inference job.
     */
    public val modelId: kotlin.String? = builder.modelId
    /**
     * Details about the location of the output of the batch inference job.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobOutputDataConfig? = builder.outputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference. You can use the console to create a default service role or follow the steps at [Create a service role for batch inference](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Any tags to associate with the batch inference job. For more information, see [Tagging Amazon Bedrock resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The number of hours after which to force the batch inference job to time out.
     */
    public val timeoutDurationInHours: kotlin.Int? = builder.timeoutDurationInHours
    /**
     * The configuration of the Virtual Private Cloud (VPC) for the data in the batch inference job. For more information, see [Protect batch inference jobs using a VPC](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-vpc).
     */
    public val vpcConfig: aws.sdk.kotlin.services.bedrock.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.CreateModelInvocationJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelInvocationJobRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobName=$jobName,")
        append("modelId=$modelId,")
        append("outputDataConfig=$outputDataConfig,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("timeoutDurationInHours=$timeoutDurationInHours,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (modelId?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeoutDurationInHours ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateModelInvocationJobRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobName != other.jobName) return false
        if (modelId != other.modelId) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (timeoutDurationInHours != other.timeoutDurationInHours) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.CreateModelInvocationJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Details about the location of the input to the batch inference job.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobInputDataConfig? = null
        /**
         * A name to give the batch inference job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The unique identifier of the foundation model to use for the batch inference job.
         */
        public var modelId: kotlin.String? = null
        /**
         * Details about the location of the output of the batch inference job.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobOutputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference. You can use the console to create a default service role or follow the steps at [Create a service role for batch inference](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html).
         */
        public var roleArn: kotlin.String? = null
        /**
         * Any tags to associate with the batch inference job. For more information, see [Tagging Amazon Bedrock resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
         */
        public var tags: List<Tag>? = null
        /**
         * The number of hours after which to force the batch inference job to time out.
         */
        public var timeoutDurationInHours: kotlin.Int? = null
        /**
         * The configuration of the Virtual Private Cloud (VPC) for the data in the batch inference job. For more information, see [Protect batch inference jobs using a VPC](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-vpc).
         */
        public var vpcConfig: aws.sdk.kotlin.services.bedrock.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.CreateModelInvocationJobRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.inputDataConfig = x.inputDataConfig
            this.jobName = x.jobName
            this.modelId = x.modelId
            this.outputDataConfig = x.outputDataConfig
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.timeoutDurationInHours = x.timeoutDurationInHours
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.CreateModelInvocationJobRequest = CreateModelInvocationJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.bedrock.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.bedrock.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
