// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateModelImportJobRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The imported model is encrypted at rest using this key.
     */
    public val importedModelKmsKeyId: kotlin.String? = builder.importedModelKmsKeyId
    /**
     * The name of the imported model.
     */
    public val importedModelName: kotlin.String? = builder.importedModelName
    /**
     * Tags to attach to the imported model.
     */
    public val importedModelTags: List<Tag>? = builder.importedModelTags
    /**
     * The name of the import job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * Tags to attach to this import job.
     */
    public val jobTags: List<Tag>? = builder.jobTags
    /**
     * The data source for the imported model.
     */
    public val modelDataSource: aws.sdk.kotlin.services.bedrock.model.ModelDataSource? = builder.modelDataSource
    /**
     * The Amazon Resource Name (ARN) of the model import job.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * VPC configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for the import job.
     */
    public val vpcConfig: aws.sdk.kotlin.services.bedrock.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.CreateModelImportJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelImportJobRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("importedModelKmsKeyId=$importedModelKmsKeyId,")
        append("importedModelName=$importedModelName,")
        append("importedModelTags=$importedModelTags,")
        append("jobName=$jobName,")
        append("jobTags=$jobTags,")
        append("modelDataSource=$modelDataSource,")
        append("roleArn=$roleArn,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (importedModelKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (importedModelName?.hashCode() ?: 0)
        result = 31 * result + (importedModelTags?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobTags?.hashCode() ?: 0)
        result = 31 * result + (modelDataSource?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateModelImportJobRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (importedModelKmsKeyId != other.importedModelKmsKeyId) return false
        if (importedModelName != other.importedModelName) return false
        if (importedModelTags != other.importedModelTags) return false
        if (jobName != other.jobName) return false
        if (jobTags != other.jobTags) return false
        if (modelDataSource != other.modelDataSource) return false
        if (roleArn != other.roleArn) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.CreateModelImportJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The imported model is encrypted at rest using this key.
         */
        public var importedModelKmsKeyId: kotlin.String? = null
        /**
         * The name of the imported model.
         */
        public var importedModelName: kotlin.String? = null
        /**
         * Tags to attach to the imported model.
         */
        public var importedModelTags: List<Tag>? = null
        /**
         * The name of the import job.
         */
        public var jobName: kotlin.String? = null
        /**
         * Tags to attach to this import job.
         */
        public var jobTags: List<Tag>? = null
        /**
         * The data source for the imported model.
         */
        public var modelDataSource: aws.sdk.kotlin.services.bedrock.model.ModelDataSource? = null
        /**
         * The Amazon Resource Name (ARN) of the model import job.
         */
        public var roleArn: kotlin.String? = null
        /**
         * VPC configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for the import job.
         */
        public var vpcConfig: aws.sdk.kotlin.services.bedrock.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.CreateModelImportJobRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.importedModelKmsKeyId = x.importedModelKmsKeyId
            this.importedModelName = x.importedModelName
            this.importedModelTags = x.importedModelTags
            this.jobName = x.jobName
            this.jobTags = x.jobTags
            this.modelDataSource = x.modelDataSource
            this.roleArn = x.roleArn
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.CreateModelImportJobRequest = CreateModelImportJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.bedrock.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.bedrock.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
