// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateModelCopyJobRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The ARN of the KMS key that you use to encrypt the model copy.
     */
    public val modelKmsKeyId: kotlin.String? = builder.modelKmsKeyId
    /**
     * The Amazon Resource Name (ARN) of the model to be copied.
     */
    public val sourceModelArn: kotlin.String? = builder.sourceModelArn
    /**
     * A name for the copied model.
     */
    public val targetModelName: kotlin.String? = builder.targetModelName
    /**
     * Tags to associate with the target model. For more information, see [Tag resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public val targetModelTags: List<Tag>? = builder.targetModelTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.CreateModelCopyJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelCopyJobRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("modelKmsKeyId=$modelKmsKeyId,")
        append("sourceModelArn=$sourceModelArn,")
        append("targetModelName=$targetModelName,")
        append("targetModelTags=$targetModelTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (modelKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (sourceModelArn?.hashCode() ?: 0)
        result = 31 * result + (targetModelName?.hashCode() ?: 0)
        result = 31 * result + (targetModelTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateModelCopyJobRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (modelKmsKeyId != other.modelKmsKeyId) return false
        if (sourceModelArn != other.sourceModelArn) return false
        if (targetModelName != other.targetModelName) return false
        if (targetModelTags != other.targetModelTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.CreateModelCopyJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The ARN of the KMS key that you use to encrypt the model copy.
         */
        public var modelKmsKeyId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the model to be copied.
         */
        public var sourceModelArn: kotlin.String? = null
        /**
         * A name for the copied model.
         */
        public var targetModelName: kotlin.String? = null
        /**
         * Tags to associate with the target model. For more information, see [Tag resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
         */
        public var targetModelTags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.CreateModelCopyJobRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.modelKmsKeyId = x.modelKmsKeyId
            this.sourceModelArn = x.sourceModelArn
            this.targetModelName = x.targetModelName
            this.targetModelTags = x.targetModelTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.CreateModelCopyJobRequest = CreateModelCopyJobRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
