// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateEvaluationJobRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Specify your customer managed key ARN that will be used to encrypt your model evaluation job.
     */
    public val customerEncryptionKeyId: kotlin.String? = builder.customerEncryptionKeyId
    /**
     * Specifies whether the model evaluation job is automatic or uses human worker.
     */
    public val evaluationConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationConfig? = builder.evaluationConfig
    /**
     * Specify the models you want to use in your model evaluation job. Automatic model evaluation jobs support a single model or [inference profile](https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html), and model evaluation job that use human workers support two models or inference profiles.
     */
    public val inferenceConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationInferenceConfig? = builder.inferenceConfig
    /**
     * A description of the model evaluation job.
     */
    public val jobDescription: kotlin.String? = builder.jobDescription
    /**
     * The name of the model evaluation job. Model evaluation job names must unique with your AWS account, and your account's AWS region.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * Tags to attach to the model evaluation job.
     */
    public val jobTags: List<Tag>? = builder.jobTags
    /**
     * An object that defines where the results of model evaluation job will be saved in Amazon S3.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig? = builder.outputDataConfig
    /**
     * The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks on your behalf. The service role must have Amazon Bedrock as the service principal, and provide access to any Amazon S3 buckets specified in the `EvaluationConfig` object. To pass this role to Amazon Bedrock, the caller of this API must have the `iam:PassRole` permission. To learn more about the required permissions, see [Required permissions](https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.CreateEvaluationJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEvaluationJobRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("customerEncryptionKeyId=$customerEncryptionKeyId,")
        append("evaluationConfig=$evaluationConfig,")
        append("inferenceConfig=$inferenceConfig,")
        append("jobDescription=*** Sensitive Data Redacted ***,")
        append("jobName=$jobName,")
        append("jobTags=$jobTags,")
        append("outputDataConfig=$outputDataConfig,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (customerEncryptionKeyId?.hashCode() ?: 0)
        result = 31 * result + (evaluationConfig?.hashCode() ?: 0)
        result = 31 * result + (inferenceConfig?.hashCode() ?: 0)
        result = 31 * result + (jobDescription?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobTags?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEvaluationJobRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (customerEncryptionKeyId != other.customerEncryptionKeyId) return false
        if (evaluationConfig != other.evaluationConfig) return false
        if (inferenceConfig != other.inferenceConfig) return false
        if (jobDescription != other.jobDescription) return false
        if (jobName != other.jobName) return false
        if (jobTags != other.jobTags) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.CreateEvaluationJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Specify your customer managed key ARN that will be used to encrypt your model evaluation job.
         */
        public var customerEncryptionKeyId: kotlin.String? = null
        /**
         * Specifies whether the model evaluation job is automatic or uses human worker.
         */
        public var evaluationConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationConfig? = null
        /**
         * Specify the models you want to use in your model evaluation job. Automatic model evaluation jobs support a single model or [inference profile](https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html), and model evaluation job that use human workers support two models or inference profiles.
         */
        public var inferenceConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationInferenceConfig? = null
        /**
         * A description of the model evaluation job.
         */
        public var jobDescription: kotlin.String? = null
        /**
         * The name of the model evaluation job. Model evaluation job names must unique with your AWS account, and your account's AWS region.
         */
        public var jobName: kotlin.String? = null
        /**
         * Tags to attach to the model evaluation job.
         */
        public var jobTags: List<Tag>? = null
        /**
         * An object that defines where the results of model evaluation job will be saved in Amazon S3.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks on your behalf. The service role must have Amazon Bedrock as the service principal, and provide access to any Amazon S3 buckets specified in the `EvaluationConfig` object. To pass this role to Amazon Bedrock, the caller of this API must have the `iam:PassRole` permission. To learn more about the required permissions, see [Required permissions](https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security.html).
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.CreateEvaluationJobRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.customerEncryptionKeyId = x.customerEncryptionKeyId
            this.evaluationConfig = x.evaluationConfig
            this.inferenceConfig = x.inferenceConfig
            this.jobDescription = x.jobDescription
            this.jobName = x.jobName
            this.jobTags = x.jobTags
            this.outputDataConfig = x.outputDataConfig
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.CreateEvaluationJobRequest = CreateEvaluationJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
