// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.bedrock.auth.BedrockAuthSchemeProvider
import aws.sdk.kotlin.services.bedrock.auth.DefaultBedrockAuthSchemeProvider
import aws.sdk.kotlin.services.bedrock.endpoints.BedrockEndpointParameters
import aws.sdk.kotlin.services.bedrock.endpoints.BedrockEndpointProvider
import aws.sdk.kotlin.services.bedrock.endpoints.DefaultBedrockEndpointProvider
import aws.sdk.kotlin.services.bedrock.model.BatchDeleteEvaluationJobRequest
import aws.sdk.kotlin.services.bedrock.model.BatchDeleteEvaluationJobResponse
import aws.sdk.kotlin.services.bedrock.model.CreateEvaluationJobRequest
import aws.sdk.kotlin.services.bedrock.model.CreateEvaluationJobResponse
import aws.sdk.kotlin.services.bedrock.model.CreateGuardrailRequest
import aws.sdk.kotlin.services.bedrock.model.CreateGuardrailResponse
import aws.sdk.kotlin.services.bedrock.model.CreateGuardrailVersionRequest
import aws.sdk.kotlin.services.bedrock.model.CreateGuardrailVersionResponse
import aws.sdk.kotlin.services.bedrock.model.CreateModelCopyJobRequest
import aws.sdk.kotlin.services.bedrock.model.CreateModelCopyJobResponse
import aws.sdk.kotlin.services.bedrock.model.CreateModelCustomizationJobRequest
import aws.sdk.kotlin.services.bedrock.model.CreateModelCustomizationJobResponse
import aws.sdk.kotlin.services.bedrock.model.CreateModelImportJobRequest
import aws.sdk.kotlin.services.bedrock.model.CreateModelImportJobResponse
import aws.sdk.kotlin.services.bedrock.model.CreateModelInvocationJobRequest
import aws.sdk.kotlin.services.bedrock.model.CreateModelInvocationJobResponse
import aws.sdk.kotlin.services.bedrock.model.CreateProvisionedModelThroughputRequest
import aws.sdk.kotlin.services.bedrock.model.CreateProvisionedModelThroughputResponse
import aws.sdk.kotlin.services.bedrock.model.DeleteCustomModelRequest
import aws.sdk.kotlin.services.bedrock.model.DeleteCustomModelResponse
import aws.sdk.kotlin.services.bedrock.model.DeleteGuardrailRequest
import aws.sdk.kotlin.services.bedrock.model.DeleteGuardrailResponse
import aws.sdk.kotlin.services.bedrock.model.DeleteImportedModelRequest
import aws.sdk.kotlin.services.bedrock.model.DeleteImportedModelResponse
import aws.sdk.kotlin.services.bedrock.model.DeleteModelInvocationLoggingConfigurationRequest
import aws.sdk.kotlin.services.bedrock.model.DeleteModelInvocationLoggingConfigurationResponse
import aws.sdk.kotlin.services.bedrock.model.DeleteProvisionedModelThroughputRequest
import aws.sdk.kotlin.services.bedrock.model.DeleteProvisionedModelThroughputResponse
import aws.sdk.kotlin.services.bedrock.model.GetCustomModelRequest
import aws.sdk.kotlin.services.bedrock.model.GetCustomModelResponse
import aws.sdk.kotlin.services.bedrock.model.GetEvaluationJobRequest
import aws.sdk.kotlin.services.bedrock.model.GetEvaluationJobResponse
import aws.sdk.kotlin.services.bedrock.model.GetFoundationModelRequest
import aws.sdk.kotlin.services.bedrock.model.GetFoundationModelResponse
import aws.sdk.kotlin.services.bedrock.model.GetGuardrailRequest
import aws.sdk.kotlin.services.bedrock.model.GetGuardrailResponse
import aws.sdk.kotlin.services.bedrock.model.GetImportedModelRequest
import aws.sdk.kotlin.services.bedrock.model.GetImportedModelResponse
import aws.sdk.kotlin.services.bedrock.model.GetInferenceProfileRequest
import aws.sdk.kotlin.services.bedrock.model.GetInferenceProfileResponse
import aws.sdk.kotlin.services.bedrock.model.GetModelCopyJobRequest
import aws.sdk.kotlin.services.bedrock.model.GetModelCopyJobResponse
import aws.sdk.kotlin.services.bedrock.model.GetModelCustomizationJobRequest
import aws.sdk.kotlin.services.bedrock.model.GetModelCustomizationJobResponse
import aws.sdk.kotlin.services.bedrock.model.GetModelImportJobRequest
import aws.sdk.kotlin.services.bedrock.model.GetModelImportJobResponse
import aws.sdk.kotlin.services.bedrock.model.GetModelInvocationJobRequest
import aws.sdk.kotlin.services.bedrock.model.GetModelInvocationJobResponse
import aws.sdk.kotlin.services.bedrock.model.GetModelInvocationLoggingConfigurationRequest
import aws.sdk.kotlin.services.bedrock.model.GetModelInvocationLoggingConfigurationResponse
import aws.sdk.kotlin.services.bedrock.model.GetProvisionedModelThroughputRequest
import aws.sdk.kotlin.services.bedrock.model.GetProvisionedModelThroughputResponse
import aws.sdk.kotlin.services.bedrock.model.ListCustomModelsRequest
import aws.sdk.kotlin.services.bedrock.model.ListCustomModelsResponse
import aws.sdk.kotlin.services.bedrock.model.ListEvaluationJobsRequest
import aws.sdk.kotlin.services.bedrock.model.ListEvaluationJobsResponse
import aws.sdk.kotlin.services.bedrock.model.ListFoundationModelsRequest
import aws.sdk.kotlin.services.bedrock.model.ListFoundationModelsResponse
import aws.sdk.kotlin.services.bedrock.model.ListGuardrailsRequest
import aws.sdk.kotlin.services.bedrock.model.ListGuardrailsResponse
import aws.sdk.kotlin.services.bedrock.model.ListImportedModelsRequest
import aws.sdk.kotlin.services.bedrock.model.ListImportedModelsResponse
import aws.sdk.kotlin.services.bedrock.model.ListInferenceProfilesRequest
import aws.sdk.kotlin.services.bedrock.model.ListInferenceProfilesResponse
import aws.sdk.kotlin.services.bedrock.model.ListModelCopyJobsRequest
import aws.sdk.kotlin.services.bedrock.model.ListModelCopyJobsResponse
import aws.sdk.kotlin.services.bedrock.model.ListModelCustomizationJobsRequest
import aws.sdk.kotlin.services.bedrock.model.ListModelCustomizationJobsResponse
import aws.sdk.kotlin.services.bedrock.model.ListModelImportJobsRequest
import aws.sdk.kotlin.services.bedrock.model.ListModelImportJobsResponse
import aws.sdk.kotlin.services.bedrock.model.ListModelInvocationJobsRequest
import aws.sdk.kotlin.services.bedrock.model.ListModelInvocationJobsResponse
import aws.sdk.kotlin.services.bedrock.model.ListProvisionedModelThroughputsRequest
import aws.sdk.kotlin.services.bedrock.model.ListProvisionedModelThroughputsResponse
import aws.sdk.kotlin.services.bedrock.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.bedrock.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.bedrock.model.PutModelInvocationLoggingConfigurationRequest
import aws.sdk.kotlin.services.bedrock.model.PutModelInvocationLoggingConfigurationResponse
import aws.sdk.kotlin.services.bedrock.model.StopEvaluationJobRequest
import aws.sdk.kotlin.services.bedrock.model.StopEvaluationJobResponse
import aws.sdk.kotlin.services.bedrock.model.StopModelCustomizationJobRequest
import aws.sdk.kotlin.services.bedrock.model.StopModelCustomizationJobResponse
import aws.sdk.kotlin.services.bedrock.model.StopModelInvocationJobRequest
import aws.sdk.kotlin.services.bedrock.model.StopModelInvocationJobResponse
import aws.sdk.kotlin.services.bedrock.model.TagResourceRequest
import aws.sdk.kotlin.services.bedrock.model.TagResourceResponse
import aws.sdk.kotlin.services.bedrock.model.UntagResourceRequest
import aws.sdk.kotlin.services.bedrock.model.UntagResourceResponse
import aws.sdk.kotlin.services.bedrock.model.UpdateGuardrailRequest
import aws.sdk.kotlin.services.bedrock.model.UpdateGuardrailResponse
import aws.sdk.kotlin.services.bedrock.model.UpdateProvisionedModelThroughputRequest
import aws.sdk.kotlin.services.bedrock.model.UpdateProvisionedModelThroughputResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Bedrock"
public const val SdkVersion: String = "1.3.63"
public const val ServiceApiVersion: String = "2023-04-20"

/**
 * Describes the API operations for creating, managing, fine-turning, and evaluating Amazon Bedrock models.
 */
public interface BedrockClient : SdkClient {
    /**
     * BedrockClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, BedrockClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Bedrock",
                "BEDROCK",
                "bedrock",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, BedrockClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): BedrockClient = DefaultBedrockClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: BedrockEndpointProvider = builder.endpointProvider ?: DefaultBedrockEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: BedrockAuthSchemeProvider = builder.authSchemeProvider ?: DefaultBedrockAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Bedrock"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: BedrockEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: BedrockAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a batch deletion job. A model evaluation job can only be deleted if it has following status `FAILED`, `COMPLETED`, and `STOPPED`. You can request up to 25 model evaluation jobs be deleted in a single request.
     */
    public suspend fun batchDeleteEvaluationJob(input: BatchDeleteEvaluationJobRequest): BatchDeleteEvaluationJobResponse

    /**
     * API operation for creating and managing Amazon Bedrock automatic model evaluation jobs and model evaluation jobs that use human workers. To learn more about the requirements for creating a model evaluation job see, [Model evaluation](https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation.html).
     */
    public suspend fun createEvaluationJob(input: CreateEvaluationJobRequest): CreateEvaluationJobResponse

    /**
     * Creates a guardrail to block topics and to implement safeguards for your generative AI applications.
     *
     * You can configure the following policies in a guardrail to avoid undesirable and harmful content, filter out denied topics and words, and remove sensitive information for privacy protection.
     * + **Content filters** - Adjust filter strengths to block input prompts or model responses containing harmful content.
     * + **Denied topics** - Define a set of topics that are undesirable in the context of your application. These topics will be blocked if detected in user queries or model responses.
     * + **Word filters** - Configure filters to block undesirable words, phrases, and profanity. Such words can include offensive terms, competitor names etc.
     * + **Sensitive information filters** - Block or mask sensitive information such as personally identifiable information (PII) or custom regex in user inputs and model responses.
     *
     * In addition to the above policies, you can also configure the messages to be returned to the user if a user input or model response is in violation of the policies defined in the guardrail.
     *
     * For more information, see [Guardrails for Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html) in the *Amazon Bedrock User Guide*.
     */
    public suspend fun createGuardrail(input: CreateGuardrailRequest): CreateGuardrailResponse

    /**
     * Creates a version of the guardrail. Use this API to create a snapshot of the guardrail when you are satisfied with a configuration, or to compare the configuration with another version.
     */
    public suspend fun createGuardrailVersion(input: CreateGuardrailVersionRequest): CreateGuardrailVersionResponse

    /**
     * Copies a model to another region so that it can be used there. For more information, see [Copy models to be used in other regions](https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun createModelCopyJob(input: CreateModelCopyJobRequest): CreateModelCopyJobResponse

    /**
     * Creates a fine-tuning job to customize a base model.
     *
     * You specify the base foundation model and the location of the training data. After the model-customization job completes successfully, your custom model resource will be ready to use. Amazon Bedrock returns validation loss metrics and output generations after the job completes.
     *
     * For information on the format of training and validation data, see [Prepare the datasets](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-prepare.html).
     *
     *  Model-customization jobs are asynchronous and the completion time depends on the base model and the training/validation data size. To monitor a job, use the `GetModelCustomizationJob` operation to retrieve the job status.
     *
     * For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun createModelCustomizationJob(input: CreateModelCustomizationJobRequest): CreateModelCustomizationJobResponse

    /**
     * Creates a model import job to import model that you have customized in other environments, such as Amazon SageMaker. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html)
     */
    public suspend fun createModelImportJob(input: CreateModelImportJobRequest): CreateModelImportJobResponse

    /**
     * Creates a batch inference job to invoke a model on multiple prompts. Format your data according to [Format your inference data](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data) and upload it to an Amazon S3 bucket. For more information, see [Process multiple prompts with batch inference](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference.html).
     *
     * The response returns a `jobArn` that you can use to stop or get details about the job.
     */
    public suspend fun createModelInvocationJob(input: CreateModelInvocationJobRequest): CreateModelInvocationJobResponse

    /**
     * Creates dedicated throughput for a base or custom model with the model units and for the duration that you specify. For pricing details, see [Amazon Bedrock Pricing](http://aws.amazon.com/bedrock/pricing/). For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun createProvisionedModelThroughput(input: CreateProvisionedModelThroughputRequest): CreateProvisionedModelThroughputResponse

    /**
     * Deletes a custom model that you created earlier. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun deleteCustomModel(input: DeleteCustomModelRequest): DeleteCustomModelResponse

    /**
     * Deletes a guardrail.
     * + To delete a guardrail, only specify the ARN of the guardrail in the `guardrailIdentifier` field. If you delete a guardrail, all of its versions will be deleted.
     * + To delete a version of a guardrail, specify the ARN of the guardrail in the `guardrailIdentifier` field and the version in the `guardrailVersion` field.
     */
    public suspend fun deleteGuardrail(input: DeleteGuardrailRequest): DeleteGuardrailResponse

    /**
     * Deletes a custom model that you imported earlier. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun deleteImportedModel(input: DeleteImportedModelRequest): DeleteImportedModelResponse

    /**
     * Delete the invocation logging.
     */
    public suspend fun deleteModelInvocationLoggingConfiguration(input: DeleteModelInvocationLoggingConfigurationRequest = DeleteModelInvocationLoggingConfigurationRequest { }): DeleteModelInvocationLoggingConfigurationResponse

    /**
     * Deletes a Provisioned Throughput. You can't delete a Provisioned Throughput before the commitment term is over. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun deleteProvisionedModelThroughput(input: DeleteProvisionedModelThroughputRequest): DeleteProvisionedModelThroughputResponse

    /**
     * Get the properties associated with a Amazon Bedrock custom model that you have created.For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun getCustomModel(input: GetCustomModelRequest): GetCustomModelResponse

    /**
     * Retrieves the properties associated with a model evaluation job, including the status of the job. For more information, see [Model evaluation](https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation.html).
     */
    public suspend fun getEvaluationJob(input: GetEvaluationJobRequest): GetEvaluationJobResponse

    /**
     * Get details about a Amazon Bedrock foundation model.
     */
    public suspend fun getFoundationModel(input: GetFoundationModelRequest): GetFoundationModelResponse

    /**
     * Gets details about a guardrail. If you don't specify a version, the response returns details for the `DRAFT` version.
     */
    public suspend fun getGuardrail(input: GetGuardrailRequest): GetGuardrailResponse

    /**
     * Gets properties associated with a customized model you imported.
     */
    public suspend fun getImportedModel(input: GetImportedModelRequest): GetImportedModelResponse

    /**
     * Gets information about an inference profile. For more information, see the Amazon Bedrock User Guide.
     */
    public suspend fun getInferenceProfile(input: GetInferenceProfileRequest): GetInferenceProfileResponse

    /**
     * Retrieves information about a model copy job. For more information, see [Copy models to be used in other regions](https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun getModelCopyJob(input: GetModelCopyJobRequest): GetModelCopyJobResponse

    /**
     * Retrieves the properties associated with a model-customization job, including the status of the job. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun getModelCustomizationJob(input: GetModelCustomizationJobRequest): GetModelCustomizationJobResponse

    /**
     * Retrieves the properties associated with import model job, including the status of the job. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun getModelImportJob(input: GetModelImportJobRequest): GetModelImportJobResponse

    /**
     * Gets details about a batch inference job. For more information, see [View details about a batch inference job](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-manage.html#batch-inference-view)
     */
    public suspend fun getModelInvocationJob(input: GetModelInvocationJobRequest): GetModelInvocationJobResponse

    /**
     * Get the current configuration values for model invocation logging.
     */
    public suspend fun getModelInvocationLoggingConfiguration(input: GetModelInvocationLoggingConfigurationRequest = GetModelInvocationLoggingConfigurationRequest { }): GetModelInvocationLoggingConfigurationResponse

    /**
     * Returns details for a Provisioned Throughput. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun getProvisionedModelThroughput(input: GetProvisionedModelThroughputRequest): GetProvisionedModelThroughputResponse

    /**
     * Returns a list of the custom models that you have created with the `CreateModelCustomizationJob` operation.
     *
     * For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun listCustomModels(input: ListCustomModelsRequest = ListCustomModelsRequest { }): ListCustomModelsResponse

    /**
     * Lists model evaluation jobs.
     */
    public suspend fun listEvaluationJobs(input: ListEvaluationJobsRequest = ListEvaluationJobsRequest { }): ListEvaluationJobsResponse

    /**
     * Lists Amazon Bedrock foundation models that you can use. You can filter the results with the request parameters. For more information, see [Foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/foundation-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun listFoundationModels(input: ListFoundationModelsRequest = ListFoundationModelsRequest { }): ListFoundationModelsResponse

    /**
     * Lists details about all the guardrails in an account. To list the `DRAFT` version of all your guardrails, don't specify the `guardrailIdentifier` field. To list all versions of a guardrail, specify the ARN of the guardrail in the `guardrailIdentifier` field.
     *
     * You can set the maximum number of results to return in a response in the `maxResults` field. If there are more results than the number you set, the response returns a `nextToken` that you can send in another `ListGuardrails` request to see the next batch of results.
     */
    public suspend fun listGuardrails(input: ListGuardrailsRequest = ListGuardrailsRequest { }): ListGuardrailsResponse

    /**
     * Returns a list of models you've imported. You can filter the results to return based on one or more criteria. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun listImportedModels(input: ListImportedModelsRequest = ListImportedModelsRequest { }): ListImportedModelsResponse

    /**
     * Returns a list of inference profiles that you can use.
     */
    public suspend fun listInferenceProfiles(input: ListInferenceProfilesRequest = ListInferenceProfilesRequest { }): ListInferenceProfilesResponse

    /**
     * Returns a list of model copy jobs that you have submitted. You can filter the jobs to return based on one or more criteria. For more information, see [Copy models to be used in other regions](https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun listModelCopyJobs(input: ListModelCopyJobsRequest = ListModelCopyJobsRequest { }): ListModelCopyJobsResponse

    /**
     * Returns a list of model customization jobs that you have submitted. You can filter the jobs to return based on one or more criteria.
     *
     * For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun listModelCustomizationJobs(input: ListModelCustomizationJobsRequest = ListModelCustomizationJobsRequest { }): ListModelCustomizationJobsResponse

    /**
     * Returns a list of import jobs you've submitted. You can filter the results to return based on one or more criteria. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun listModelImportJobs(input: ListModelImportJobsRequest = ListModelImportJobsRequest { }): ListModelImportJobsResponse

    /**
     * Lists all batch inference jobs in the account. For more information, see [View details about a batch inference job](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-manage.html#batch-inference-view).
     */
    public suspend fun listModelInvocationJobs(input: ListModelInvocationJobsRequest = ListModelInvocationJobsRequest { }): ListModelInvocationJobsResponse

    /**
     * Lists the Provisioned Throughputs in the account. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun listProvisionedModelThroughputs(input: ListProvisionedModelThroughputsRequest = ListProvisionedModelThroughputsRequest { }): ListProvisionedModelThroughputsResponse

    /**
     * List the tags associated with the specified resource.
     *
     * For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Set the configuration values for model invocation logging.
     */
    public suspend fun putModelInvocationLoggingConfiguration(input: PutModelInvocationLoggingConfigurationRequest): PutModelInvocationLoggingConfigurationResponse

    /**
     * Stops an in progress model evaluation job.
     */
    public suspend fun stopEvaluationJob(input: StopEvaluationJobRequest): StopEvaluationJobResponse

    /**
     * Stops an active model customization job. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun stopModelCustomizationJob(input: StopModelCustomizationJobRequest): StopModelCustomizationJobResponse

    /**
     * Stops a batch inference job. You're only charged for tokens that were already processed. For more information, see [Stop a batch inference job](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-manage.html#batch-inference-stop).
     */
    public suspend fun stopModelInvocationJob(input: StopModelInvocationJobRequest): StopModelInvocationJobResponse

    /**
     * Associate tags with a resource. For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove one or more tags from a resource. For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a guardrail with the values you specify.
     * + Specify a `name` and optional `description`.
     * + Specify messages for when the guardrail successfully blocks a prompt or a model response in the `blockedInputMessaging` and `blockedOutputsMessaging` fields.
     * + Specify topics for the guardrail to deny in the `topicPolicyConfig` object. Each [GuardrailTopicConfig](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailTopicConfig.html) object in the `topicsConfig` list pertains to one topic.
     *    + Give a `name` and `description` so that the guardrail can properly identify the topic.
     *    + Specify `DENY` in the `type` field.
     *    + (Optional) Provide up to five prompts that you would categorize as belonging to the topic in the `examples` list.
     * + Specify filter strengths for the harmful categories defined in Amazon Bedrock in the `contentPolicyConfig` object. Each [GuardrailContentFilterConfig](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html) object in the `filtersConfig` list pertains to a harmful category. For more information, see [Content filters](https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-content-filters). For more information about the fields in a content filter, see [GuardrailContentFilterConfig](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html).
     *    + Specify the category in the `type` field.
     *    + Specify the strength of the filter for prompts in the `inputStrength` field and for model responses in the `strength` field of the [GuardrailContentFilterConfig](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html).
     * + (Optional) For security, include the ARN of a KMS key in the `kmsKeyId` field.
     */
    public suspend fun updateGuardrail(input: UpdateGuardrailRequest): UpdateGuardrailResponse

    /**
     * Updates the name or associated model for a Provisioned Throughput. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
     */
    public suspend fun updateProvisionedModelThroughput(input: UpdateProvisionedModelThroughputRequest): UpdateProvisionedModelThroughputResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun BedrockClient.withConfig(block: BedrockClient.Config.Builder.() -> Unit): BedrockClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultBedrockClient(newConfig)
}

/**
 * Creates a batch deletion job. A model evaluation job can only be deleted if it has following status `FAILED`, `COMPLETED`, and `STOPPED`. You can request up to 25 model evaluation jobs be deleted in a single request.
 */
public suspend inline fun BedrockClient.batchDeleteEvaluationJob(crossinline block: BatchDeleteEvaluationJobRequest.Builder.() -> Unit): BatchDeleteEvaluationJobResponse = batchDeleteEvaluationJob(BatchDeleteEvaluationJobRequest.Builder().apply(block).build())

/**
 * API operation for creating and managing Amazon Bedrock automatic model evaluation jobs and model evaluation jobs that use human workers. To learn more about the requirements for creating a model evaluation job see, [Model evaluation](https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation.html).
 */
public suspend inline fun BedrockClient.createEvaluationJob(crossinline block: CreateEvaluationJobRequest.Builder.() -> Unit): CreateEvaluationJobResponse = createEvaluationJob(CreateEvaluationJobRequest.Builder().apply(block).build())

/**
 * Creates a guardrail to block topics and to implement safeguards for your generative AI applications.
 *
 * You can configure the following policies in a guardrail to avoid undesirable and harmful content, filter out denied topics and words, and remove sensitive information for privacy protection.
 * + **Content filters** - Adjust filter strengths to block input prompts or model responses containing harmful content.
 * + **Denied topics** - Define a set of topics that are undesirable in the context of your application. These topics will be blocked if detected in user queries or model responses.
 * + **Word filters** - Configure filters to block undesirable words, phrases, and profanity. Such words can include offensive terms, competitor names etc.
 * + **Sensitive information filters** - Block or mask sensitive information such as personally identifiable information (PII) or custom regex in user inputs and model responses.
 *
 * In addition to the above policies, you can also configure the messages to be returned to the user if a user input or model response is in violation of the policies defined in the guardrail.
 *
 * For more information, see [Guardrails for Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html) in the *Amazon Bedrock User Guide*.
 */
public suspend inline fun BedrockClient.createGuardrail(crossinline block: CreateGuardrailRequest.Builder.() -> Unit): CreateGuardrailResponse = createGuardrail(CreateGuardrailRequest.Builder().apply(block).build())

/**
 * Creates a version of the guardrail. Use this API to create a snapshot of the guardrail when you are satisfied with a configuration, or to compare the configuration with another version.
 */
public suspend inline fun BedrockClient.createGuardrailVersion(crossinline block: CreateGuardrailVersionRequest.Builder.() -> Unit): CreateGuardrailVersionResponse = createGuardrailVersion(CreateGuardrailVersionRequest.Builder().apply(block).build())

/**
 * Copies a model to another region so that it can be used there. For more information, see [Copy models to be used in other regions](https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.createModelCopyJob(crossinline block: CreateModelCopyJobRequest.Builder.() -> Unit): CreateModelCopyJobResponse = createModelCopyJob(CreateModelCopyJobRequest.Builder().apply(block).build())

/**
 * Creates a fine-tuning job to customize a base model.
 *
 * You specify the base foundation model and the location of the training data. After the model-customization job completes successfully, your custom model resource will be ready to use. Amazon Bedrock returns validation loss metrics and output generations after the job completes.
 *
 * For information on the format of training and validation data, see [Prepare the datasets](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-prepare.html).
 *
 *  Model-customization jobs are asynchronous and the completion time depends on the base model and the training/validation data size. To monitor a job, use the `GetModelCustomizationJob` operation to retrieve the job status.
 *
 * For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.createModelCustomizationJob(crossinline block: CreateModelCustomizationJobRequest.Builder.() -> Unit): CreateModelCustomizationJobResponse = createModelCustomizationJob(CreateModelCustomizationJobRequest.Builder().apply(block).build())

/**
 * Creates a model import job to import model that you have customized in other environments, such as Amazon SageMaker. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html)
 */
public suspend inline fun BedrockClient.createModelImportJob(crossinline block: CreateModelImportJobRequest.Builder.() -> Unit): CreateModelImportJobResponse = createModelImportJob(CreateModelImportJobRequest.Builder().apply(block).build())

/**
 * Creates a batch inference job to invoke a model on multiple prompts. Format your data according to [Format your inference data](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data) and upload it to an Amazon S3 bucket. For more information, see [Process multiple prompts with batch inference](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference.html).
 *
 * The response returns a `jobArn` that you can use to stop or get details about the job.
 */
public suspend inline fun BedrockClient.createModelInvocationJob(crossinline block: CreateModelInvocationJobRequest.Builder.() -> Unit): CreateModelInvocationJobResponse = createModelInvocationJob(CreateModelInvocationJobRequest.Builder().apply(block).build())

/**
 * Creates dedicated throughput for a base or custom model with the model units and for the duration that you specify. For pricing details, see [Amazon Bedrock Pricing](http://aws.amazon.com/bedrock/pricing/). For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.createProvisionedModelThroughput(crossinline block: CreateProvisionedModelThroughputRequest.Builder.() -> Unit): CreateProvisionedModelThroughputResponse = createProvisionedModelThroughput(CreateProvisionedModelThroughputRequest.Builder().apply(block).build())

/**
 * Deletes a custom model that you created earlier. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.deleteCustomModel(crossinline block: DeleteCustomModelRequest.Builder.() -> Unit): DeleteCustomModelResponse = deleteCustomModel(DeleteCustomModelRequest.Builder().apply(block).build())

/**
 * Deletes a guardrail.
 * + To delete a guardrail, only specify the ARN of the guardrail in the `guardrailIdentifier` field. If you delete a guardrail, all of its versions will be deleted.
 * + To delete a version of a guardrail, specify the ARN of the guardrail in the `guardrailIdentifier` field and the version in the `guardrailVersion` field.
 */
public suspend inline fun BedrockClient.deleteGuardrail(crossinline block: DeleteGuardrailRequest.Builder.() -> Unit): DeleteGuardrailResponse = deleteGuardrail(DeleteGuardrailRequest.Builder().apply(block).build())

/**
 * Deletes a custom model that you imported earlier. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.deleteImportedModel(crossinline block: DeleteImportedModelRequest.Builder.() -> Unit): DeleteImportedModelResponse = deleteImportedModel(DeleteImportedModelRequest.Builder().apply(block).build())

/**
 * Delete the invocation logging.
 */
public suspend inline fun BedrockClient.deleteModelInvocationLoggingConfiguration(crossinline block: DeleteModelInvocationLoggingConfigurationRequest.Builder.() -> Unit): DeleteModelInvocationLoggingConfigurationResponse = deleteModelInvocationLoggingConfiguration(DeleteModelInvocationLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a Provisioned Throughput. You can't delete a Provisioned Throughput before the commitment term is over. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.deleteProvisionedModelThroughput(crossinline block: DeleteProvisionedModelThroughputRequest.Builder.() -> Unit): DeleteProvisionedModelThroughputResponse = deleteProvisionedModelThroughput(DeleteProvisionedModelThroughputRequest.Builder().apply(block).build())

/**
 * Get the properties associated with a Amazon Bedrock custom model that you have created.For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.getCustomModel(crossinline block: GetCustomModelRequest.Builder.() -> Unit): GetCustomModelResponse = getCustomModel(GetCustomModelRequest.Builder().apply(block).build())

/**
 * Retrieves the properties associated with a model evaluation job, including the status of the job. For more information, see [Model evaluation](https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation.html).
 */
public suspend inline fun BedrockClient.getEvaluationJob(crossinline block: GetEvaluationJobRequest.Builder.() -> Unit): GetEvaluationJobResponse = getEvaluationJob(GetEvaluationJobRequest.Builder().apply(block).build())

/**
 * Get details about a Amazon Bedrock foundation model.
 */
public suspend inline fun BedrockClient.getFoundationModel(crossinline block: GetFoundationModelRequest.Builder.() -> Unit): GetFoundationModelResponse = getFoundationModel(GetFoundationModelRequest.Builder().apply(block).build())

/**
 * Gets details about a guardrail. If you don't specify a version, the response returns details for the `DRAFT` version.
 */
public suspend inline fun BedrockClient.getGuardrail(crossinline block: GetGuardrailRequest.Builder.() -> Unit): GetGuardrailResponse = getGuardrail(GetGuardrailRequest.Builder().apply(block).build())

/**
 * Gets properties associated with a customized model you imported.
 */
public suspend inline fun BedrockClient.getImportedModel(crossinline block: GetImportedModelRequest.Builder.() -> Unit): GetImportedModelResponse = getImportedModel(GetImportedModelRequest.Builder().apply(block).build())

/**
 * Gets information about an inference profile. For more information, see the Amazon Bedrock User Guide.
 */
public suspend inline fun BedrockClient.getInferenceProfile(crossinline block: GetInferenceProfileRequest.Builder.() -> Unit): GetInferenceProfileResponse = getInferenceProfile(GetInferenceProfileRequest.Builder().apply(block).build())

/**
 * Retrieves information about a model copy job. For more information, see [Copy models to be used in other regions](https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.getModelCopyJob(crossinline block: GetModelCopyJobRequest.Builder.() -> Unit): GetModelCopyJobResponse = getModelCopyJob(GetModelCopyJobRequest.Builder().apply(block).build())

/**
 * Retrieves the properties associated with a model-customization job, including the status of the job. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.getModelCustomizationJob(crossinline block: GetModelCustomizationJobRequest.Builder.() -> Unit): GetModelCustomizationJobResponse = getModelCustomizationJob(GetModelCustomizationJobRequest.Builder().apply(block).build())

/**
 * Retrieves the properties associated with import model job, including the status of the job. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.getModelImportJob(crossinline block: GetModelImportJobRequest.Builder.() -> Unit): GetModelImportJobResponse = getModelImportJob(GetModelImportJobRequest.Builder().apply(block).build())

/**
 * Gets details about a batch inference job. For more information, see [View details about a batch inference job](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-manage.html#batch-inference-view)
 */
public suspend inline fun BedrockClient.getModelInvocationJob(crossinline block: GetModelInvocationJobRequest.Builder.() -> Unit): GetModelInvocationJobResponse = getModelInvocationJob(GetModelInvocationJobRequest.Builder().apply(block).build())

/**
 * Get the current configuration values for model invocation logging.
 */
public suspend inline fun BedrockClient.getModelInvocationLoggingConfiguration(crossinline block: GetModelInvocationLoggingConfigurationRequest.Builder.() -> Unit): GetModelInvocationLoggingConfigurationResponse = getModelInvocationLoggingConfiguration(GetModelInvocationLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Returns details for a Provisioned Throughput. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.getProvisionedModelThroughput(crossinline block: GetProvisionedModelThroughputRequest.Builder.() -> Unit): GetProvisionedModelThroughputResponse = getProvisionedModelThroughput(GetProvisionedModelThroughputRequest.Builder().apply(block).build())

/**
 * Returns a list of the custom models that you have created with the `CreateModelCustomizationJob` operation.
 *
 * For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.listCustomModels(crossinline block: ListCustomModelsRequest.Builder.() -> Unit): ListCustomModelsResponse = listCustomModels(ListCustomModelsRequest.Builder().apply(block).build())

/**
 * Lists model evaluation jobs.
 */
public suspend inline fun BedrockClient.listEvaluationJobs(crossinline block: ListEvaluationJobsRequest.Builder.() -> Unit): ListEvaluationJobsResponse = listEvaluationJobs(ListEvaluationJobsRequest.Builder().apply(block).build())

/**
 * Lists Amazon Bedrock foundation models that you can use. You can filter the results with the request parameters. For more information, see [Foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/foundation-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.listFoundationModels(crossinline block: ListFoundationModelsRequest.Builder.() -> Unit): ListFoundationModelsResponse = listFoundationModels(ListFoundationModelsRequest.Builder().apply(block).build())

/**
 * Lists details about all the guardrails in an account. To list the `DRAFT` version of all your guardrails, don't specify the `guardrailIdentifier` field. To list all versions of a guardrail, specify the ARN of the guardrail in the `guardrailIdentifier` field.
 *
 * You can set the maximum number of results to return in a response in the `maxResults` field. If there are more results than the number you set, the response returns a `nextToken` that you can send in another `ListGuardrails` request to see the next batch of results.
 */
public suspend inline fun BedrockClient.listGuardrails(crossinline block: ListGuardrailsRequest.Builder.() -> Unit): ListGuardrailsResponse = listGuardrails(ListGuardrailsRequest.Builder().apply(block).build())

/**
 * Returns a list of models you've imported. You can filter the results to return based on one or more criteria. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.listImportedModels(crossinline block: ListImportedModelsRequest.Builder.() -> Unit): ListImportedModelsResponse = listImportedModels(ListImportedModelsRequest.Builder().apply(block).build())

/**
 * Returns a list of inference profiles that you can use.
 */
public suspend inline fun BedrockClient.listInferenceProfiles(crossinline block: ListInferenceProfilesRequest.Builder.() -> Unit): ListInferenceProfilesResponse = listInferenceProfiles(ListInferenceProfilesRequest.Builder().apply(block).build())

/**
 * Returns a list of model copy jobs that you have submitted. You can filter the jobs to return based on one or more criteria. For more information, see [Copy models to be used in other regions](https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.listModelCopyJobs(crossinline block: ListModelCopyJobsRequest.Builder.() -> Unit): ListModelCopyJobsResponse = listModelCopyJobs(ListModelCopyJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of model customization jobs that you have submitted. You can filter the jobs to return based on one or more criteria.
 *
 * For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.listModelCustomizationJobs(crossinline block: ListModelCustomizationJobsRequest.Builder.() -> Unit): ListModelCustomizationJobsResponse = listModelCustomizationJobs(ListModelCustomizationJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of import jobs you've submitted. You can filter the results to return based on one or more criteria. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.listModelImportJobs(crossinline block: ListModelImportJobsRequest.Builder.() -> Unit): ListModelImportJobsResponse = listModelImportJobs(ListModelImportJobsRequest.Builder().apply(block).build())

/**
 * Lists all batch inference jobs in the account. For more information, see [View details about a batch inference job](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-manage.html#batch-inference-view).
 */
public suspend inline fun BedrockClient.listModelInvocationJobs(crossinline block: ListModelInvocationJobsRequest.Builder.() -> Unit): ListModelInvocationJobsResponse = listModelInvocationJobs(ListModelInvocationJobsRequest.Builder().apply(block).build())

/**
 * Lists the Provisioned Throughputs in the account. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.listProvisionedModelThroughputs(crossinline block: ListProvisionedModelThroughputsRequest.Builder.() -> Unit): ListProvisionedModelThroughputsResponse = listProvisionedModelThroughputs(ListProvisionedModelThroughputsRequest.Builder().apply(block).build())

/**
 * List the tags associated with the specified resource.
 *
 * For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Set the configuration values for model invocation logging.
 */
public suspend inline fun BedrockClient.putModelInvocationLoggingConfiguration(crossinline block: PutModelInvocationLoggingConfigurationRequest.Builder.() -> Unit): PutModelInvocationLoggingConfigurationResponse = putModelInvocationLoggingConfiguration(PutModelInvocationLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Stops an in progress model evaluation job.
 */
public suspend inline fun BedrockClient.stopEvaluationJob(crossinline block: StopEvaluationJobRequest.Builder.() -> Unit): StopEvaluationJobResponse = stopEvaluationJob(StopEvaluationJobRequest.Builder().apply(block).build())

/**
 * Stops an active model customization job. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.stopModelCustomizationJob(crossinline block: StopModelCustomizationJobRequest.Builder.() -> Unit): StopModelCustomizationJobResponse = stopModelCustomizationJob(StopModelCustomizationJobRequest.Builder().apply(block).build())

/**
 * Stops a batch inference job. You're only charged for tokens that were already processed. For more information, see [Stop a batch inference job](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-manage.html#batch-inference-stop).
 */
public suspend inline fun BedrockClient.stopModelInvocationJob(crossinline block: StopModelInvocationJobRequest.Builder.() -> Unit): StopModelInvocationJobResponse = stopModelInvocationJob(StopModelInvocationJobRequest.Builder().apply(block).build())

/**
 * Associate tags with a resource. For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove one or more tags from a resource. For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a guardrail with the values you specify.
 * + Specify a `name` and optional `description`.
 * + Specify messages for when the guardrail successfully blocks a prompt or a model response in the `blockedInputMessaging` and `blockedOutputsMessaging` fields.
 * + Specify topics for the guardrail to deny in the `topicPolicyConfig` object. Each [GuardrailTopicConfig](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailTopicConfig.html) object in the `topicsConfig` list pertains to one topic.
 *    + Give a `name` and `description` so that the guardrail can properly identify the topic.
 *    + Specify `DENY` in the `type` field.
 *    + (Optional) Provide up to five prompts that you would categorize as belonging to the topic in the `examples` list.
 * + Specify filter strengths for the harmful categories defined in Amazon Bedrock in the `contentPolicyConfig` object. Each [GuardrailContentFilterConfig](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html) object in the `filtersConfig` list pertains to a harmful category. For more information, see [Content filters](https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-content-filters). For more information about the fields in a content filter, see [GuardrailContentFilterConfig](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html).
 *    + Specify the category in the `type` field.
 *    + Specify the strength of the filter for prompts in the `inputStrength` field and for model responses in the `strength` field of the [GuardrailContentFilterConfig](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html).
 * + (Optional) For security, include the ARN of a KMS key in the `kmsKeyId` field.
 */
public suspend inline fun BedrockClient.updateGuardrail(crossinline block: UpdateGuardrailRequest.Builder.() -> Unit): UpdateGuardrailResponse = updateGuardrail(UpdateGuardrailRequest.Builder().apply(block).build())

/**
 * Updates the name or associated model for a Provisioned Throughput. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html).
 */
public suspend inline fun BedrockClient.updateProvisionedModelThroughput(crossinline block: UpdateProvisionedModelThroughputRequest.Builder.() -> Unit): UpdateProvisionedModelThroughputResponse = updateProvisionedModelThroughput(UpdateProvisionedModelThroughputRequest.Builder().apply(block).build())
