// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.serde

import aws.sdk.kotlin.services.backupstorage.model.BackupStorageException
import aws.sdk.kotlin.services.backupstorage.model.DataChecksumAlgorithm
import aws.sdk.kotlin.services.backupstorage.model.GetObjectMetadataResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toByteStream
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class GetObjectMetadataOperationDeserializer: HttpDeserializer.Streaming<GetObjectMetadataResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetObjectMetadataResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            val payload = response.body.readAll()
            throwGetObjectMetadataError(context, call, payload)
        }
        val builder = GetObjectMetadataResponse.Builder()

        builder.metadataBlobChecksum = response.headers["x-amz-checksum"]
        builder.metadataBlobChecksumAlgorithm = response.headers["x-amz-checksum-algorithm"]?.let { DataChecksumAlgorithm.fromValue(it) }
        builder.metadataBlobLength = response.headers["x-amz-data-length"]?.toLong() ?: 0L
        builder.metadataString = response.headers["x-amz-metadata-string"]

        builder.metadataBlob = response.body.toByteStream()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetObjectMetadataError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupStorageException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RetryableException" -> RetryableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceInternalException" -> ServiceInternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInvalidKeyUsageException" -> KmsInvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BackupStorageException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
