// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.paginators

import aws.sdk.kotlin.services.backupstorage.BackupStorageClient
import aws.sdk.kotlin.services.backupstorage.model.ListChunksRequest
import aws.sdk.kotlin.services.backupstorage.model.ListChunksResponse
import aws.sdk.kotlin.services.backupstorage.model.ListObjectsRequest
import aws.sdk.kotlin.services.backupstorage.model.ListObjectsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListChunksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChunksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChunksResponse]
 */
public fun BackupStorageClient.listChunksPaginated(initialRequest: ListChunksRequest): Flow<ListChunksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChunksPaginated.listChunks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChunksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChunksResponse]
 */
public fun BackupStorageClient.listChunksPaginated(block: ListChunksRequest.Builder.() -> Unit): Flow<ListChunksResponse> =
    listChunksPaginated(ListChunksRequest.Builder().apply(block).build())

/**
 * Paginate over [ListObjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListObjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectsResponse]
 */
public fun BackupStorageClient.listObjectsPaginated(initialRequest: ListObjectsRequest): Flow<ListObjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listObjectsPaginated.listObjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListObjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectsResponse]
 */
public fun BackupStorageClient.listObjectsPaginated(block: ListObjectsRequest.Builder.() -> Unit): Flow<ListObjectsResponse> =
    listObjectsPaginated(ListObjectsRequest.Builder().apply(block).build())
