// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.serde

import aws.sdk.kotlin.services.backupstorage.model.DataChecksumAlgorithm
import aws.sdk.kotlin.services.backupstorage.model.PutChunkRequest
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutChunkOperationSerializer: HttpSerialize<PutChunkRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutChunkRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.backupJobId) { "backupJobId is bound to the URI and must not be null" }
            requireNotNull(input.uploadId) { "uploadId is bound to the URI and must not be null" }
            requireNotNull(input.chunkIndex) { "chunkIndex is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("backup-jobs"))
                add(PercentEncoding.SmithyLabel.encode("${input.backupJobId}"))
                add(PercentEncoding.Path.encode("chunk"))
                add(PercentEncoding.SmithyLabel.encode("${input.uploadId}"))
                add(PercentEncoding.SmithyLabel.encode("${input.chunkIndex}"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.checksum != null) add("checksum", input.checksum)
                if (input.checksumAlgorithm != null) add("checksum-algorithm", input.checksumAlgorithm.value)
                if (input.length != null) add("length", "${input.length}")
            }
        }

        if (input.data != null) {
            builder.body = input.data.toHttpBody()
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.data == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
