// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.serde

import aws.sdk.kotlin.services.backupstorage.model.ListObjectsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListObjectsOperationSerializer: HttpSerialize<ListObjectsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListObjectsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.storageJobId) { "storageJobId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("restore-jobs"))
                add(PercentEncoding.SmithyLabel.encode("${input.storageJobId}"))
                add(PercentEncoding.Path.encode("objects"))
                add(PercentEncoding.Path.encode("list"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.createdAfter != null) add("created-after", input.createdAfter.format(TimestampFormat.ISO_8601))
                if (input.createdBefore != null) add("created-before", input.createdBefore.format(TimestampFormat.ISO_8601))
                if (input.maxResults != null) add("max-results", "${input.maxResults}")
                if (input.nextToken != null) add("next-token", input.nextToken)
                if (input.startingObjectName != null) add("starting-object-name", input.startingObjectName)
                if (input.startingObjectPrefix != null) add("starting-object-prefix", input.startingObjectPrefix)
            }
        }

        return builder
    }
}
