// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.serde

import aws.sdk.kotlin.services.backupstorage.model.DataChecksumAlgorithm
import aws.sdk.kotlin.services.backupstorage.model.NotifyObjectCompleteRequest
import aws.sdk.kotlin.services.backupstorage.model.SummaryChecksumAlgorithm
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class NotifyObjectCompleteOperationSerializer: HttpSerialize<NotifyObjectCompleteRequest> {
    override suspend fun serialize(context: ExecutionContext, input: NotifyObjectCompleteRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.backupJobId) { "backupJobId is bound to the URI and must not be null" }
            requireNotNull(input.uploadId) { "uploadId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("backup-jobs"))
                add(PercentEncoding.SmithyLabel.encode("${input.backupJobId}"))
                add(PercentEncoding.Path.encode("object"))
                add(PercentEncoding.SmithyLabel.encode("${input.uploadId}"))
                add(PercentEncoding.Path.encode("complete"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.metadataBlobChecksum != null) add("metadata-checksum", input.metadataBlobChecksum)
                if (input.metadataBlobChecksumAlgorithm != null) add("metadata-checksum-algorithm", input.metadataBlobChecksumAlgorithm.value)
                if (input.metadataBlobLength != null) add("metadata-blob-length", "${input.metadataBlobLength}")
                if (input.metadataString != null) add("metadata-string", input.metadataString)
                if (input.objectChecksum != null) add("checksum", input.objectChecksum)
                if (input.objectChecksumAlgorithm != null) add("checksum-algorithm", input.objectChecksumAlgorithm.value)
            }
        }

        if (input.metadataBlob != null) {
            builder.body = input.metadataBlob.toHttpBody()
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.metadataBlob == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
