// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.serde

import aws.sdk.kotlin.services.backupstorage.model.PutObjectRequest
import aws.sdk.kotlin.services.backupstorage.model.SummaryChecksumAlgorithm
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutObjectOperationSerializer: HttpSerialize<PutObjectRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutObjectRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.backupJobId) { "backupJobId is bound to the URI and must not be null" }
            requireNotNull(input.objectName) { "objectName is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "backup-jobs",
                "${input.backupJobId}".encodeLabel(),
                "object",
                "${input.objectName}".encodeLabel(),
                "put-object",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.inlineChunkChecksum != null) append("checksum", input.inlineChunkChecksum)
                if (input.inlineChunkChecksumAlgorithm != null) append("checksum-algorithm", input.inlineChunkChecksumAlgorithm)
                if (input.inlineChunkLength != null) append("length", "${input.inlineChunkLength}")
                if (input.metadataString != null) append("metadata-string", input.metadataString)
                if (input.objectChecksum != null) append("object-checksum", input.objectChecksum)
                if (input.objectChecksumAlgorithm != null) append("object-checksum-algorithm", input.objectChecksumAlgorithm.value)
                if (input.throwOnDuplicate != null) append("throwOnDuplicate", "${input.throwOnDuplicate}")
            }
        }

        if (input.inlineChunk != null) {
            builder.body = input.inlineChunk.toHttpBody()
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.inlineChunk == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
