// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.serde

import aws.sdk.kotlin.services.backupstorage.model.BackupStorageException
import aws.sdk.kotlin.services.backupstorage.model.DataChecksumAlgorithm
import aws.sdk.kotlin.services.backupstorage.model.PutObjectResponse
import aws.sdk.kotlin.services.backupstorage.model.SummaryChecksumAlgorithm
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutObjectOperationDeserializer: HttpDeserialize<PutObjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutObjectResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutObjectError(context, call)
        }
        val builder = PutObjectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutObjectOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutObjectError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupStorageException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSInvalidKeyUsageException" -> KmsInvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedCall)
        "NotReadableInputStreamException" -> NotReadableInputStreamExceptionDeserializer().deserialize(context, wrappedCall)
        "RetryableException" -> RetryableExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceInternalException" -> ServiceInternalExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> BackupStorageException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutObjectOperationBody(builder: PutObjectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INLINECHUNKCHECKSUM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InlineChunkChecksum"))
    val INLINECHUNKCHECKSUMALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("InlineChunkChecksumAlgorithm"))
    val OBJECTCHECKSUM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ObjectChecksum"))
    val OBJECTCHECKSUMALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ObjectChecksumAlgorithm"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INLINECHUNKCHECKSUM_DESCRIPTOR)
        field(INLINECHUNKCHECKSUMALGORITHM_DESCRIPTOR)
        field(OBJECTCHECKSUM_DESCRIPTOR)
        field(OBJECTCHECKSUMALGORITHM_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INLINECHUNKCHECKSUM_DESCRIPTOR.index -> builder.inlineChunkChecksum = deserializeString()
                INLINECHUNKCHECKSUMALGORITHM_DESCRIPTOR.index -> builder.inlineChunkChecksumAlgorithm = deserializeString().let { DataChecksumAlgorithm.fromValue(it) }
                OBJECTCHECKSUM_DESCRIPTOR.index -> builder.objectChecksum = deserializeString()
                OBJECTCHECKSUMALGORITHM_DESCRIPTOR.index -> builder.objectChecksumAlgorithm = deserializeString().let { SummaryChecksumAlgorithm.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
