// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.serde

import aws.sdk.kotlin.services.backupstorage.model.DataChecksumAlgorithm
import aws.sdk.kotlin.services.backupstorage.model.PutChunkRequest
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutChunkOperationSerializer: HttpSerialize<PutChunkRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutChunkRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.backupJobId) { "backupJobId is bound to the URI and must not be null" }
            requireNotNull(input.uploadId) { "uploadId is bound to the URI and must not be null" }
            requireNotNull(input.chunkIndex) { "chunkIndex is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "backup-jobs",
                "${input.backupJobId}".encodeLabel(),
                "chunk",
                "${input.uploadId}".encodeLabel(),
                "${input.chunkIndex}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.checksum != null) append("checksum", input.checksum)
                if (input.checksumAlgorithm != null) append("checksum-algorithm", input.checksumAlgorithm.value)
                if (input.length != null) append("length", "${input.length}")
            }
        }

        if (input.data != null) {
            builder.body = input.data.toHttpBody()
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.data == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
