// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.serde

import aws.sdk.kotlin.services.backupstorage.model.ListChunksRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class ListChunksOperationSerializer: HttpSerialize<ListChunksRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListChunksRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.storageJobId) { "storageJobId is bound to the URI and must not be null" }
            requireNotNull(input.objectToken) { "objectToken is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "restore-jobs",
                "${input.storageJobId}".encodeLabel(),
                "chunks",
                "${input.objectToken}".encodeLabel(),
                "list",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.maxResults != null) append("max-results", "${input.maxResults}")
                if (input.nextToken != null) append("next-token", input.nextToken)
            }
        }

        return builder
    }
}
