// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.backupstorage.auth.BackupStorageAuthSchemeProvider
import aws.sdk.kotlin.services.backupstorage.auth.DefaultBackupStorageAuthSchemeProvider
import aws.sdk.kotlin.services.backupstorage.endpoints.BackupStorageEndpointParameters
import aws.sdk.kotlin.services.backupstorage.endpoints.BackupStorageEndpointProvider
import aws.sdk.kotlin.services.backupstorage.endpoints.DefaultBackupStorageEndpointProvider
import aws.sdk.kotlin.services.backupstorage.model.DeleteObjectRequest
import aws.sdk.kotlin.services.backupstorage.model.DeleteObjectResponse
import aws.sdk.kotlin.services.backupstorage.model.GetChunkRequest
import aws.sdk.kotlin.services.backupstorage.model.GetChunkResponse
import aws.sdk.kotlin.services.backupstorage.model.GetObjectMetadataRequest
import aws.sdk.kotlin.services.backupstorage.model.GetObjectMetadataResponse
import aws.sdk.kotlin.services.backupstorage.model.ListChunksRequest
import aws.sdk.kotlin.services.backupstorage.model.ListChunksResponse
import aws.sdk.kotlin.services.backupstorage.model.ListObjectsRequest
import aws.sdk.kotlin.services.backupstorage.model.ListObjectsResponse
import aws.sdk.kotlin.services.backupstorage.model.NotifyObjectCompleteRequest
import aws.sdk.kotlin.services.backupstorage.model.NotifyObjectCompleteResponse
import aws.sdk.kotlin.services.backupstorage.model.PutChunkRequest
import aws.sdk.kotlin.services.backupstorage.model.PutChunkResponse
import aws.sdk.kotlin.services.backupstorage.model.PutObjectRequest
import aws.sdk.kotlin.services.backupstorage.model.PutObjectResponse
import aws.sdk.kotlin.services.backupstorage.model.StartObjectRequest
import aws.sdk.kotlin.services.backupstorage.model.StartObjectResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "BackupStorage"
public const val SdkVersion: String = "0.33.0-beta"

/**
 * The frontend service for Cryo Storage.
 */
public interface BackupStorageClient : SdkClient {
    /**
     * BackupStorageClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, BackupStorageClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.interceptors.add(0, ClockSkewInterceptor())
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "BackupStorage",
                "BACKUPSTORAGE",
                "backupstorage",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, BackupStorageClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): BackupStorageClient = DefaultBackupStorageClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: BackupStorageAuthSchemeProvider = builder.authSchemeProvider ?: DefaultBackupStorageAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: BackupStorageEndpointProvider = builder.endpointProvider ?: DefaultBackupStorageEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "BackupStorage"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: BackupStorageAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: BackupStorageEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Delete Object from the incremental base Backup.
     */
    public suspend fun deleteObject(input: DeleteObjectRequest): DeleteObjectResponse

    /**
     * Gets the specified object's chunk.
     */
    public suspend fun <T> getChunk(input: GetChunkRequest, block: suspend (GetChunkResponse) -> T): T

    /**
     * Get metadata associated with an Object.
     */
    public suspend fun <T> getObjectMetadata(input: GetObjectMetadataRequest, block: suspend (GetObjectMetadataResponse) -> T): T

    /**
     * List chunks in a given Object
     */
    public suspend fun listChunks(input: ListChunksRequest): ListChunksResponse

    /**
     * List all Objects in a given Backup.
     */
    public suspend fun listObjects(input: ListObjectsRequest): ListObjectsResponse

    /**
     * Complete upload
     */
    public suspend fun notifyObjectComplete(input: NotifyObjectCompleteRequest): NotifyObjectCompleteResponse

    /**
     * Upload chunk.
     */
    public suspend fun putChunk(input: PutChunkRequest): PutChunkResponse

    /**
     * Upload object that can store object metadata String and data blob in single API call using inline chunk field.
     */
    public suspend fun putObject(input: PutObjectRequest): PutObjectResponse

    /**
     * Start upload containing one or many chunks.
     */
    public suspend fun startObject(input: StartObjectRequest): StartObjectResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun BackupStorageClient.withConfig(block: BackupStorageClient.Config.Builder.() -> Unit): BackupStorageClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultBackupStorageClient(newConfig)
}

/**
 * Delete Object from the incremental base Backup.
 */
public suspend inline fun BackupStorageClient.deleteObject(crossinline block: DeleteObjectRequest.Builder.() -> Unit): DeleteObjectResponse = deleteObject(DeleteObjectRequest.Builder().apply(block).build())

/**
 * List chunks in a given Object
 */
public suspend inline fun BackupStorageClient.listChunks(crossinline block: ListChunksRequest.Builder.() -> Unit): ListChunksResponse = listChunks(ListChunksRequest.Builder().apply(block).build())

/**
 * List all Objects in a given Backup.
 */
public suspend inline fun BackupStorageClient.listObjects(crossinline block: ListObjectsRequest.Builder.() -> Unit): ListObjectsResponse = listObjects(ListObjectsRequest.Builder().apply(block).build())

/**
 * Complete upload
 */
public suspend inline fun BackupStorageClient.notifyObjectComplete(crossinline block: NotifyObjectCompleteRequest.Builder.() -> Unit): NotifyObjectCompleteResponse = notifyObjectComplete(NotifyObjectCompleteRequest.Builder().apply(block).build())

/**
 * Upload chunk.
 */
public suspend inline fun BackupStorageClient.putChunk(crossinline block: PutChunkRequest.Builder.() -> Unit): PutChunkResponse = putChunk(PutChunkRequest.Builder().apply(block).build())

/**
 * Upload object that can store object metadata String and data blob in single API call using inline chunk field.
 */
public suspend inline fun BackupStorageClient.putObject(crossinline block: PutObjectRequest.Builder.() -> Unit): PutObjectResponse = putObject(PutObjectRequest.Builder().apply(block).build())

/**
 * Start upload containing one or many chunks.
 */
public suspend inline fun BackupStorageClient.startObject(crossinline block: StartObjectRequest.Builder.() -> Unit): StartObjectResponse = startObject(StartObjectRequest.Builder().apply(block).build())
