// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backupstorage.model.BackupStorageException
import aws.sdk.kotlin.services.backupstorage.model.StartObjectResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartObjectOperationDeserializer: HttpDeserialize<StartObjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartObjectResponse {
        if (!response.status.isSuccess()) {
            throwStartObjectError(context, response)
        }
        val builder = StartObjectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartObjectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartObjectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupStorageException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DataAlreadyExistsException" -> DataAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "RetryableException" -> RetryableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceInternalException" -> ServiceInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupStorageException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartObjectOperationBody(builder: StartObjectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val UPLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UploadId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(UPLOADID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                UPLOADID_DESCRIPTOR.index -> builder.uploadId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
