// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backupstorage.model.BackupStorageException
import aws.sdk.kotlin.services.backupstorage.model.DataChecksumAlgorithm
import aws.sdk.kotlin.services.backupstorage.model.PutObjectResponse
import aws.sdk.kotlin.services.backupstorage.model.SummaryChecksumAlgorithm
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutObjectOperationDeserializer: HttpDeserialize<PutObjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutObjectResponse {
        if (!response.status.isSuccess()) {
            throwPutObjectError(context, response)
        }
        val builder = PutObjectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutObjectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutObjectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupStorageException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidKeyUsageException" -> KmsInvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotReadableInputStreamException" -> NotReadableInputStreamExceptionDeserializer().deserialize(context, wrappedResponse)
        "RetryableException" -> RetryableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceInternalException" -> ServiceInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupStorageException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutObjectOperationBody(builder: PutObjectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INLINECHUNKCHECKSUM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InlineChunkChecksum"))
    val INLINECHUNKCHECKSUMALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InlineChunkChecksumAlgorithm"))
    val OBJECTCHECKSUM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ObjectChecksum"))
    val OBJECTCHECKSUMALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ObjectChecksumAlgorithm"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INLINECHUNKCHECKSUM_DESCRIPTOR)
        field(INLINECHUNKCHECKSUMALGORITHM_DESCRIPTOR)
        field(OBJECTCHECKSUM_DESCRIPTOR)
        field(OBJECTCHECKSUMALGORITHM_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INLINECHUNKCHECKSUM_DESCRIPTOR.index -> builder.inlineChunkChecksum = deserializeString()
                INLINECHUNKCHECKSUMALGORITHM_DESCRIPTOR.index -> builder.inlineChunkChecksumAlgorithm = deserializeString().let { DataChecksumAlgorithm.fromValue(it) }
                OBJECTCHECKSUM_DESCRIPTOR.index -> builder.objectChecksum = deserializeString()
                OBJECTCHECKSUMALGORITHM_DESCRIPTOR.index -> builder.objectChecksumAlgorithm = deserializeString().let { SummaryChecksumAlgorithm.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
