// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backupstorage.model.BackupStorageException
import aws.sdk.kotlin.services.backupstorage.model.DataChecksumAlgorithm
import aws.sdk.kotlin.services.backupstorage.model.PutChunkResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutChunkOperationDeserializer: HttpDeserialize<PutChunkResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutChunkResponse {
        if (!response.status.isSuccess()) {
            throwPutChunkError(context, response)
        }
        val builder = PutChunkResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutChunkOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutChunkError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupStorageException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidKeyUsageException" -> KmsInvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotReadableInputStreamException" -> NotReadableInputStreamExceptionDeserializer().deserialize(context, wrappedResponse)
        "RetryableException" -> RetryableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceInternalException" -> ServiceInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupStorageException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutChunkOperationBody(builder: PutChunkResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHUNKCHECKSUM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChunkChecksum"))
    val CHUNKCHECKSUMALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChunkChecksumAlgorithm"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHUNKCHECKSUM_DESCRIPTOR)
        field(CHUNKCHECKSUMALGORITHM_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHUNKCHECKSUM_DESCRIPTOR.index -> builder.chunkChecksum = deserializeString()
                CHUNKCHECKSUMALGORITHM_DESCRIPTOR.index -> builder.chunkChecksumAlgorithm = deserializeString().let { DataChecksumAlgorithm.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
