// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.transform

import aws.sdk.kotlin.services.backupstorage.model.DataChecksumAlgorithm
import aws.sdk.kotlin.services.backupstorage.model.NotifyObjectCompleteRequest
import aws.sdk.kotlin.services.backupstorage.model.SummaryChecksumAlgorithm
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class NotifyObjectCompleteOperationSerializer: HttpSerialize<NotifyObjectCompleteRequest> {
    override suspend fun serialize(context: ExecutionContext, input: NotifyObjectCompleteRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "backup-jobs",
                "${input.backupJobId}".encodeLabel(),
                "object",
                "${input.uploadId}".encodeLabel(),
                "complete",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.metadataBlobChecksum != null) append("metadata-checksum", input.metadataBlobChecksum)
                if (input.metadataBlobChecksumAlgorithm != null) append("metadata-checksum-algorithm", input.metadataBlobChecksumAlgorithm.value)
                if (input.metadataBlobLength != 0L) append("metadata-blob-length", "${input.metadataBlobLength}")
                if (input.metadataString != null) append("metadata-string", input.metadataString)
                if (input.objectChecksum != null) append("checksum", input.objectChecksum)
                if (input.objectChecksumAlgorithm != null) append("checksum-algorithm", input.objectChecksumAlgorithm.value)
            }
        }

        if (input.metadataBlob != null) {
            builder.body = input.metadataBlob.toHttpBody() ?: HttpBody.Empty
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.metadataBlob == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
