// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage.transform

import aws.sdk.kotlin.services.backupstorage.model.ListObjectsRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListObjectsOperationSerializer: HttpSerialize<ListObjectsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListObjectsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            val pathSegments = listOf<String>(
                "restore-jobs",
                "${input.storageJobId}".encodeLabel(),
                "objects",
                "list",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.createdAfter != null) append("created-after", input.createdAfter.format(TimestampFormat.ISO_8601))
                if (input.createdBefore != null) append("created-before", input.createdBefore.format(TimestampFormat.ISO_8601))
                if (input.maxResults != 0) append("max-results", "${input.maxResults}")
                if (input.nextToken != null) append("next-token", input.nextToken)
                if (input.startingObjectName != null) append("starting-object-name", input.startingObjectName)
                if (input.startingObjectPrefix != null) append("starting-object-prefix", input.startingObjectPrefix)
            }
        }

        return builder
    }
}
