// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupstorage

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.backupstorage.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.backupstorage.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.backupstorage.model.*
import aws.sdk.kotlin.services.backupstorage.model.DeleteObjectRequest
import aws.sdk.kotlin.services.backupstorage.model.GetChunkRequest
import aws.sdk.kotlin.services.backupstorage.model.GetObjectMetadataRequest
import aws.sdk.kotlin.services.backupstorage.model.ListChunksRequest
import aws.sdk.kotlin.services.backupstorage.model.ListObjectsRequest
import aws.sdk.kotlin.services.backupstorage.model.NotifyObjectCompleteRequest
import aws.sdk.kotlin.services.backupstorage.model.PutChunkRequest
import aws.sdk.kotlin.services.backupstorage.model.PutObjectRequest
import aws.sdk.kotlin.services.backupstorage.model.StartObjectRequest
import aws.sdk.kotlin.services.backupstorage.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.execute
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "BackupStorage"
public const val ServiceApiVersion: String = "2018-04-10"
public const val SdkVersion: String = "0.20.1-beta"

internal class DefaultBackupStorageClient(override val config: BackupStorageClient.Config) : BackupStorageClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Delete Object from the incremental base Backup.
     */
    override suspend fun deleteObject(input: DeleteObjectRequest): DeleteObjectResponse {
        val op = SdkHttpOperation.build<DeleteObjectRequest, DeleteObjectResponse> {
            serializer = DeleteObjectOperationSerializer()
            deserializer = DeleteObjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteObject"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteObjectRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "backup-storage"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteObject-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the specified object's chunk.
     */
    override suspend fun <T> getChunk(input: GetChunkRequest, block: suspend (GetChunkResponse) -> T): T {
        val op = SdkHttpOperation.build<GetChunkRequest, GetChunkResponse> {
            serializer = GetChunkOperationSerializer()
            deserializer = GetChunkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetChunk"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetChunkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "backup-storage"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetChunk-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.execute(client, input, block)
        }
    }

    /**
     * Get metadata associated with an Object.
     */
    override suspend fun <T> getObjectMetadata(input: GetObjectMetadataRequest, block: suspend (GetObjectMetadataResponse) -> T): T {
        val op = SdkHttpOperation.build<GetObjectMetadataRequest, GetObjectMetadataResponse> {
            serializer = GetObjectMetadataOperationSerializer()
            deserializer = GetObjectMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetObjectMetadata"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetObjectMetadataRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "backup-storage"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetObjectMetadata-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.execute(client, input, block)
        }
    }

    /**
     * List chunks in a given Object
     */
    override suspend fun listChunks(input: ListChunksRequest): ListChunksResponse {
        val op = SdkHttpOperation.build<ListChunksRequest, ListChunksResponse> {
            serializer = ListChunksOperationSerializer()
            deserializer = ListChunksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChunks"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListChunksRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "backup-storage"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListChunks-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List all Objects in a given Backup.
     */
    override suspend fun listObjects(input: ListObjectsRequest): ListObjectsResponse {
        val op = SdkHttpOperation.build<ListObjectsRequest, ListObjectsResponse> {
            serializer = ListObjectsOperationSerializer()
            deserializer = ListObjectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListObjects"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListObjectsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "backup-storage"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListObjects-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Complete upload
     */
    override suspend fun notifyObjectComplete(input: NotifyObjectCompleteRequest): NotifyObjectCompleteResponse {
        val op = SdkHttpOperation.build<NotifyObjectCompleteRequest, NotifyObjectCompleteResponse> {
            serializer = NotifyObjectCompleteOperationSerializer()
            deserializer = NotifyObjectCompleteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "NotifyObjectComplete"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<NotifyObjectCompleteRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "backup-storage"
            this.isUnsignedPayload = true
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("NotifyObjectComplete-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Upload chunk.
     */
    override suspend fun putChunk(input: PutChunkRequest): PutChunkResponse {
        val op = SdkHttpOperation.build<PutChunkRequest, PutChunkResponse> {
            serializer = PutChunkOperationSerializer()
            deserializer = PutChunkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutChunk"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutChunkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "backup-storage"
            this.isUnsignedPayload = true
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutChunk-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Upload object that can store object metadata String and data blob in single API call using inline chunk field.
     */
    override suspend fun putObject(input: PutObjectRequest): PutObjectResponse {
        val op = SdkHttpOperation.build<PutObjectRequest, PutObjectResponse> {
            serializer = PutObjectOperationSerializer()
            deserializer = PutObjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutObject"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutObjectRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "backup-storage"
            this.isUnsignedPayload = true
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutObject-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Start upload containing one or many chunks.
     */
    override suspend fun startObject(input: StartObjectRequest): StartObjectResponse {
        val op = SdkHttpOperation.build<StartObjectRequest, StartObjectResponse> {
            serializer = StartObjectOperationSerializer()
            deserializer = StartObjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartObject"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartObjectRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "backup-storage"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartObject-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "backup-storage")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
