// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.serde

import aws.sdk.kotlin.services.backupgateway.model.BackupGatewayException
import aws.sdk.kotlin.services.backupgateway.model.GetHypervisorPropertyMappingsResponse
import aws.sdk.kotlin.services.backupgateway.model.VmwareToAwsTagMapping
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetHypervisorPropertyMappingsOperationDeserializer: HttpDeserializer.NonStreaming<GetHypervisorPropertyMappingsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetHypervisorPropertyMappingsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetHypervisorPropertyMappingsError(context, call, payload)
        }
        val builder = GetHypervisorPropertyMappingsResponse.Builder()

        if (payload != null) {
            deserializeGetHypervisorPropertyMappingsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetHypervisorPropertyMappingsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupGatewayException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BackupGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetHypervisorPropertyMappingsOperationBody(builder: GetHypervisorPropertyMappingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HYPERVISORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HypervisorArn"))
    val IAMROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IamRoleArn"))
    val VMWARETOAWSTAGMAPPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("VmwareToAwsTagMappings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HYPERVISORARN_DESCRIPTOR)
        field(IAMROLEARN_DESCRIPTOR)
        field(VMWARETOAWSTAGMAPPINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HYPERVISORARN_DESCRIPTOR.index -> builder.hypervisorArn = deserializeString()
                IAMROLEARN_DESCRIPTOR.index -> builder.iamRoleArn = deserializeString()
                VMWARETOAWSTAGMAPPINGS_DESCRIPTOR.index -> builder.vmwareToAwsTagMappings =
                    deserializer.deserializeList(VMWARETOAWSTAGMAPPINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<VmwareToAwsTagMapping>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVmwareToAwsTagMappingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
