// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.paginators

import aws.sdk.kotlin.services.backupgateway.BackupGatewayClient
import aws.sdk.kotlin.services.backupgateway.model.Gateway
import aws.sdk.kotlin.services.backupgateway.model.Hypervisor
import aws.sdk.kotlin.services.backupgateway.model.ListGatewaysRequest
import aws.sdk.kotlin.services.backupgateway.model.ListGatewaysResponse
import aws.sdk.kotlin.services.backupgateway.model.ListHypervisorsRequest
import aws.sdk.kotlin.services.backupgateway.model.ListHypervisorsResponse
import aws.sdk.kotlin.services.backupgateway.model.ListVirtualMachinesRequest
import aws.sdk.kotlin.services.backupgateway.model.ListVirtualMachinesResponse
import aws.sdk.kotlin.services.backupgateway.model.VirtualMachine
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListGatewaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGatewaysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGatewaysResponse]
 */
public fun BackupGatewayClient.listGatewaysPaginated(initialRequest: ListGatewaysRequest = ListGatewaysRequest { }): Flow<ListGatewaysResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGatewaysPaginated.listGateways(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGatewaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGatewaysResponse]
 */
public fun BackupGatewayClient.listGatewaysPaginated(block: ListGatewaysRequest.Builder.() -> Unit): Flow<ListGatewaysResponse> =
    listGatewaysPaginated(ListGatewaysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGatewaysPaginated]
 * to access the nested member [Gateway]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Gateway]
 */
@JvmName("listGatewaysResponseGateway")
public fun Flow<ListGatewaysResponse>.gateways(): Flow<Gateway> =
    transform() { response ->
        response.gateways?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListHypervisorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHypervisorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHypervisorsResponse]
 */
public fun BackupGatewayClient.listHypervisorsPaginated(initialRequest: ListHypervisorsRequest = ListHypervisorsRequest { }): Flow<ListHypervisorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listHypervisorsPaginated.listHypervisors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListHypervisorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHypervisorsResponse]
 */
public fun BackupGatewayClient.listHypervisorsPaginated(block: ListHypervisorsRequest.Builder.() -> Unit): Flow<ListHypervisorsResponse> =
    listHypervisorsPaginated(ListHypervisorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listHypervisorsPaginated]
 * to access the nested member [Hypervisor]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Hypervisor]
 */
@JvmName("listHypervisorsResponseHypervisor")
public fun Flow<ListHypervisorsResponse>.hypervisors(): Flow<Hypervisor> =
    transform() { response ->
        response.hypervisors?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVirtualMachinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVirtualMachinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVirtualMachinesResponse]
 */
public fun BackupGatewayClient.listVirtualMachinesPaginated(initialRequest: ListVirtualMachinesRequest = ListVirtualMachinesRequest { }): Flow<ListVirtualMachinesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVirtualMachinesPaginated.listVirtualMachines(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVirtualMachinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVirtualMachinesResponse]
 */
public fun BackupGatewayClient.listVirtualMachinesPaginated(block: ListVirtualMachinesRequest.Builder.() -> Unit): Flow<ListVirtualMachinesResponse> =
    listVirtualMachinesPaginated(ListVirtualMachinesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVirtualMachinesPaginated]
 * to access the nested member [VirtualMachine]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VirtualMachine]
 */
@JvmName("listVirtualMachinesResponseVirtualMachine")
public fun Flow<ListVirtualMachinesResponse>.virtualMachines(): Flow<VirtualMachine> =
    transform() { response ->
        response.virtualMachines?.forEach {
            emit(it)
        }
    }
