// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is your gateway's weekly maintenance start time including the day and time of the week. Note that values are in terms of the gateway's time zone. Can be weekly or monthly.
 */
public class MaintenanceStartTime private constructor(builder: Builder) {
    /**
     * The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.
     */
    public val dayOfMonth: kotlin.Int? = builder.dayOfMonth
    /**
     * An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents Saturday. The day of week is in the time zone of the gateway.
     */
    public val dayOfWeek: kotlin.Int? = builder.dayOfWeek
    /**
     * The hour component of the maintenance start time represented as *hh*, where *hh* is the hour (0 to 23). The hour of the day is in the time zone of the gateway.
     */
    public val hourOfDay: kotlin.Int = requireNotNull(builder.hourOfDay) { "A non-null value must be provided for hourOfDay" }
    /**
     * The minute component of the maintenance start time represented as *mm*, where *mm* is the minute (0 to 59). The minute of the hour is in the time zone of the gateway.
     */
    public val minuteOfHour: kotlin.Int = requireNotNull(builder.minuteOfHour) { "A non-null value must be provided for minuteOfHour" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backupgateway.model.MaintenanceStartTime = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MaintenanceStartTime(")
        append("dayOfMonth=$dayOfMonth,")
        append("dayOfWeek=$dayOfWeek,")
        append("hourOfDay=$hourOfDay,")
        append("minuteOfHour=$minuteOfHour")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dayOfMonth ?: 0
        result = 31 * result + (dayOfWeek ?: 0)
        result = 31 * result + (hourOfDay)
        result = 31 * result + (minuteOfHour)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MaintenanceStartTime

        if (dayOfMonth != other.dayOfMonth) return false
        if (dayOfWeek != other.dayOfWeek) return false
        if (hourOfDay != other.hourOfDay) return false
        if (minuteOfHour != other.minuteOfHour) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backupgateway.model.MaintenanceStartTime = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.
         */
        public var dayOfMonth: kotlin.Int? = null
        /**
         * An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents Saturday. The day of week is in the time zone of the gateway.
         */
        public var dayOfWeek: kotlin.Int? = null
        /**
         * The hour component of the maintenance start time represented as *hh*, where *hh* is the hour (0 to 23). The hour of the day is in the time zone of the gateway.
         */
        public var hourOfDay: kotlin.Int? = null
        /**
         * The minute component of the maintenance start time represented as *mm*, where *mm* is the minute (0 to 59). The minute of the hour is in the time zone of the gateway.
         */
        public var minuteOfHour: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backupgateway.model.MaintenanceStartTime) : this() {
            this.dayOfMonth = x.dayOfMonth
            this.dayOfWeek = x.dayOfWeek
            this.hourOfDay = x.hourOfDay
            this.minuteOfHour = x.minuteOfHour
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backupgateway.model.MaintenanceStartTime = MaintenanceStartTime(this)

        internal fun correctErrors(): Builder {
            if (hourOfDay == null) hourOfDay = 0
            if (minuteOfHour == null) minuteOfHour = 0
            return this
        }
    }
}
