// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A gateway is an Backup Gateway appliance that runs on the customer's network to provide seamless connectivity to backup storage in the Amazon Web Services Cloud.
 */
public class Gateway private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the `ListGateways` operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The display name of the gateway.
     */
    public val gatewayDisplayName: kotlin.String? = builder.gatewayDisplayName
    /**
     * The type of the gateway.
     */
    public val gatewayType: aws.sdk.kotlin.services.backupgateway.model.GatewayType? = builder.gatewayType
    /**
     * The hypervisor ID of the gateway.
     */
    public val hypervisorId: kotlin.String? = builder.hypervisorId
    /**
     * The last time Backup gateway communicated with the gateway, in Unix format and UTC time.
     */
    public val lastSeenTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSeenTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backupgateway.model.Gateway = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Gateway(")
        append("gatewayArn=$gatewayArn,")
        append("gatewayDisplayName=$gatewayDisplayName,")
        append("gatewayType=$gatewayType,")
        append("hypervisorId=$hypervisorId,")
        append("lastSeenTime=$lastSeenTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (gatewayDisplayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayType?.hashCode() ?: 0)
        result = 31 * result + (hypervisorId?.hashCode() ?: 0)
        result = 31 * result + (lastSeenTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Gateway

        if (gatewayArn != other.gatewayArn) return false
        if (gatewayDisplayName != other.gatewayDisplayName) return false
        if (gatewayType != other.gatewayType) return false
        if (hypervisorId != other.hypervisorId) return false
        if (lastSeenTime != other.lastSeenTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backupgateway.model.Gateway = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the `ListGateways` operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The display name of the gateway.
         */
        public var gatewayDisplayName: kotlin.String? = null
        /**
         * The type of the gateway.
         */
        public var gatewayType: aws.sdk.kotlin.services.backupgateway.model.GatewayType? = null
        /**
         * The hypervisor ID of the gateway.
         */
        public var hypervisorId: kotlin.String? = null
        /**
         * The last time Backup gateway communicated with the gateway, in Unix format and UTC time.
         */
        public var lastSeenTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backupgateway.model.Gateway) : this() {
            this.gatewayArn = x.gatewayArn
            this.gatewayDisplayName = x.gatewayDisplayName
            this.gatewayType = x.gatewayType
            this.hypervisorId = x.hypervisorId
            this.lastSeenTime = x.lastSeenTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backupgateway.model.Gateway = Gateway(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
