// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of gateway.
 */
public class GatewayDetails private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the `ListGateways` operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The display name of the gateway.
     */
    public val gatewayDisplayName: kotlin.String? = builder.gatewayDisplayName
    /**
     * The type of the gateway type.
     */
    public val gatewayType: aws.sdk.kotlin.services.backupgateway.model.GatewayType? = builder.gatewayType
    /**
     * The hypervisor ID of the gateway.
     */
    public val hypervisorId: kotlin.String? = builder.hypervisorId
    /**
     * Details showing the last time Backup gateway communicated with the cloud, in Unix format and UTC time.
     */
    public val lastSeenTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSeenTime
    /**
     * Returns your gateway's weekly maintenance start time including the day and time of the week. Note that values are in terms of the gateway's time zone. Can be weekly or monthly.
     */
    public val maintenanceStartTime: aws.sdk.kotlin.services.backupgateway.model.MaintenanceStartTime? = builder.maintenanceStartTime
    /**
     * Details showing the next update availability time of the gateway.
     */
    public val nextUpdateAvailabilityTime: aws.smithy.kotlin.runtime.time.Instant? = builder.nextUpdateAvailabilityTime
    /**
     * The DNS name for the virtual private cloud (VPC) endpoint the gateway uses to connect to the cloud for backup gateway.
     */
    public val vpcEndpoint: kotlin.String? = builder.vpcEndpoint

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backupgateway.model.GatewayDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GatewayDetails(")
        append("gatewayArn=$gatewayArn,")
        append("gatewayDisplayName=$gatewayDisplayName,")
        append("gatewayType=$gatewayType,")
        append("hypervisorId=$hypervisorId,")
        append("lastSeenTime=$lastSeenTime,")
        append("maintenanceStartTime=$maintenanceStartTime,")
        append("nextUpdateAvailabilityTime=$nextUpdateAvailabilityTime,")
        append("vpcEndpoint=$vpcEndpoint")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (gatewayDisplayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayType?.hashCode() ?: 0)
        result = 31 * result + (hypervisorId?.hashCode() ?: 0)
        result = 31 * result + (lastSeenTime?.hashCode() ?: 0)
        result = 31 * result + (maintenanceStartTime?.hashCode() ?: 0)
        result = 31 * result + (nextUpdateAvailabilityTime?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GatewayDetails

        if (gatewayArn != other.gatewayArn) return false
        if (gatewayDisplayName != other.gatewayDisplayName) return false
        if (gatewayType != other.gatewayType) return false
        if (hypervisorId != other.hypervisorId) return false
        if (lastSeenTime != other.lastSeenTime) return false
        if (maintenanceStartTime != other.maintenanceStartTime) return false
        if (nextUpdateAvailabilityTime != other.nextUpdateAvailabilityTime) return false
        if (vpcEndpoint != other.vpcEndpoint) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backupgateway.model.GatewayDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the `ListGateways` operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The display name of the gateway.
         */
        public var gatewayDisplayName: kotlin.String? = null
        /**
         * The type of the gateway type.
         */
        public var gatewayType: aws.sdk.kotlin.services.backupgateway.model.GatewayType? = null
        /**
         * The hypervisor ID of the gateway.
         */
        public var hypervisorId: kotlin.String? = null
        /**
         * Details showing the last time Backup gateway communicated with the cloud, in Unix format and UTC time.
         */
        public var lastSeenTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns your gateway's weekly maintenance start time including the day and time of the week. Note that values are in terms of the gateway's time zone. Can be weekly or monthly.
         */
        public var maintenanceStartTime: aws.sdk.kotlin.services.backupgateway.model.MaintenanceStartTime? = null
        /**
         * Details showing the next update availability time of the gateway.
         */
        public var nextUpdateAvailabilityTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DNS name for the virtual private cloud (VPC) endpoint the gateway uses to connect to the cloud for backup gateway.
         */
        public var vpcEndpoint: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backupgateway.model.GatewayDetails) : this() {
            this.gatewayArn = x.gatewayArn
            this.gatewayDisplayName = x.gatewayDisplayName
            this.gatewayType = x.gatewayType
            this.hypervisorId = x.hypervisorId
            this.lastSeenTime = x.lastSeenTime
            this.maintenanceStartTime = x.maintenanceStartTime
            this.nextUpdateAvailabilityTime = x.nextUpdateAvailabilityTime
            this.vpcEndpoint = x.vpcEndpoint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backupgateway.model.GatewayDetails = GatewayDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.backupgateway.model.MaintenanceStartTime] inside the given [block]
         */
        public fun maintenanceStartTime(block: aws.sdk.kotlin.services.backupgateway.model.MaintenanceStartTime.Builder.() -> kotlin.Unit) {
            this.maintenanceStartTime = aws.sdk.kotlin.services.backupgateway.model.MaintenanceStartTime.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
