// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Your `VirtualMachine` objects, ordered by their Amazon Resource Names (ARNs).
 */
public class VirtualMachineDetails private constructor(builder: Builder) {
    /**
     * The host name of the virtual machine.
     */
    public val hostName: kotlin.String? = builder.hostName
    /**
     * The ID of the virtual machine's hypervisor.
     */
    public val hypervisorId: kotlin.String? = builder.hypervisorId
    /**
     * The most recent date a virtual machine was backed up, in Unix format and UTC time.
     */
    public val lastBackupDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastBackupDate
    /**
     * The name of the virtual machine.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The path of the virtual machine.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The Amazon Resource Name (ARN) of the virtual machine. For example, `arn:aws:backup-gateway:us-west-1:0000000000000:vm/vm-0000ABCDEFGIJKL`.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * These are the details of the VMware tags associated with the specified virtual machine.
     */
    public val vmwareTags: List<VmwareTag>? = builder.vmwareTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backupgateway.model.VirtualMachineDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualMachineDetails(")
        append("hostName=$hostName,")
        append("hypervisorId=$hypervisorId,")
        append("lastBackupDate=$lastBackupDate,")
        append("name=$name,")
        append("path=$path,")
        append("resourceArn=$resourceArn,")
        append("vmwareTags=$vmwareTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostName?.hashCode() ?: 0
        result = 31 * result + (hypervisorId?.hashCode() ?: 0)
        result = 31 * result + (lastBackupDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (vmwareTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VirtualMachineDetails

        if (hostName != other.hostName) return false
        if (hypervisorId != other.hypervisorId) return false
        if (lastBackupDate != other.lastBackupDate) return false
        if (name != other.name) return false
        if (path != other.path) return false
        if (resourceArn != other.resourceArn) return false
        if (vmwareTags != other.vmwareTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backupgateway.model.VirtualMachineDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The host name of the virtual machine.
         */
        public var hostName: kotlin.String? = null
        /**
         * The ID of the virtual machine's hypervisor.
         */
        public var hypervisorId: kotlin.String? = null
        /**
         * The most recent date a virtual machine was backed up, in Unix format and UTC time.
         */
        public var lastBackupDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the virtual machine.
         */
        public var name: kotlin.String? = null
        /**
         * The path of the virtual machine.
         */
        public var path: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the virtual machine. For example, `arn:aws:backup-gateway:us-west-1:0000000000000:vm/vm-0000ABCDEFGIJKL`.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * These are the details of the VMware tags associated with the specified virtual machine.
         */
        public var vmwareTags: List<VmwareTag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backupgateway.model.VirtualMachineDetails) : this() {
            this.hostName = x.hostName
            this.hypervisorId = x.hypervisorId
            this.lastBackupDate = x.lastBackupDate
            this.name = x.name
            this.path = x.path
            this.resourceArn = x.resourceArn
            this.vmwareTags = x.vmwareTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backupgateway.model.VirtualMachineDetails = VirtualMachineDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
