// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.model



/**
 * Describes a bandwidth rate limit interval for a gateway. A bandwidth rate limit schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a period of time on one or more days of the week, during which bandwidth rate limits are specified for uploading, downloading, or both.
 */
public class BandwidthRateLimitInterval private constructor(builder: Builder) {
    /**
     * The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This field does not appear in the response if the upload rate limit is not set.
     *
     * For Backup Gateway, the minimum value is `(Value)`.
     */
    public val averageUploadRateLimitInBitsPerSec: kotlin.Long? = builder.averageUploadRateLimitInBitsPerSec
    /**
     * The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from 0 to 6, where 0 represents Sunday and 6 represents Saturday.
     */
    public val daysOfWeek: List<Int> = requireNotNull(builder.daysOfWeek) { "A non-null value must be provided for daysOfWeek" }
    /**
     * The hour of the day to end the bandwidth rate limit interval.
     */
    public val endHourOfDay: kotlin.Int = requireNotNull(builder.endHourOfDay) { "A non-null value must be provided for endHourOfDay" }
    /**
     * The minute of the hour to end the bandwidth rate limit interval.
     *
     * The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an hour, use the value `59`.
     */
    public val endMinuteOfHour: kotlin.Int = requireNotNull(builder.endMinuteOfHour) { "A non-null value must be provided for endMinuteOfHour" }
    /**
     * The hour of the day to start the bandwidth rate limit interval.
     */
    public val startHourOfDay: kotlin.Int = requireNotNull(builder.startHourOfDay) { "A non-null value must be provided for startHourOfDay" }
    /**
     * The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of that minute. To begin an interval exactly at the start of the hour, use the value `0`.
     */
    public val startMinuteOfHour: kotlin.Int = requireNotNull(builder.startMinuteOfHour) { "A non-null value must be provided for startMinuteOfHour" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backupgateway.model.BandwidthRateLimitInterval = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BandwidthRateLimitInterval(")
        append("averageUploadRateLimitInBitsPerSec=$averageUploadRateLimitInBitsPerSec,")
        append("daysOfWeek=$daysOfWeek,")
        append("endHourOfDay=$endHourOfDay,")
        append("endMinuteOfHour=$endMinuteOfHour,")
        append("startHourOfDay=$startHourOfDay,")
        append("startMinuteOfHour=$startMinuteOfHour")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = averageUploadRateLimitInBitsPerSec?.hashCode() ?: 0
        result = 31 * result + (daysOfWeek.hashCode())
        result = 31 * result + (endHourOfDay)
        result = 31 * result + (endMinuteOfHour)
        result = 31 * result + (startHourOfDay)
        result = 31 * result + (startMinuteOfHour)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BandwidthRateLimitInterval

        if (averageUploadRateLimitInBitsPerSec != other.averageUploadRateLimitInBitsPerSec) return false
        if (daysOfWeek != other.daysOfWeek) return false
        if (endHourOfDay != other.endHourOfDay) return false
        if (endMinuteOfHour != other.endMinuteOfHour) return false
        if (startHourOfDay != other.startHourOfDay) return false
        if (startMinuteOfHour != other.startMinuteOfHour) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backupgateway.model.BandwidthRateLimitInterval = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This field does not appear in the response if the upload rate limit is not set.
         *
         * For Backup Gateway, the minimum value is `(Value)`.
         */
        public var averageUploadRateLimitInBitsPerSec: kotlin.Long? = null
        /**
         * The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from 0 to 6, where 0 represents Sunday and 6 represents Saturday.
         */
        public var daysOfWeek: List<Int>? = null
        /**
         * The hour of the day to end the bandwidth rate limit interval.
         */
        public var endHourOfDay: kotlin.Int? = null
        /**
         * The minute of the hour to end the bandwidth rate limit interval.
         *
         * The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an hour, use the value `59`.
         */
        public var endMinuteOfHour: kotlin.Int? = null
        /**
         * The hour of the day to start the bandwidth rate limit interval.
         */
        public var startHourOfDay: kotlin.Int? = null
        /**
         * The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of that minute. To begin an interval exactly at the start of the hour, use the value `0`.
         */
        public var startMinuteOfHour: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backupgateway.model.BandwidthRateLimitInterval) : this() {
            this.averageUploadRateLimitInBitsPerSec = x.averageUploadRateLimitInBitsPerSec
            this.daysOfWeek = x.daysOfWeek
            this.endHourOfDay = x.endHourOfDay
            this.endMinuteOfHour = x.endMinuteOfHour
            this.startHourOfDay = x.startHourOfDay
            this.startMinuteOfHour = x.startMinuteOfHour
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backupgateway.model.BandwidthRateLimitInterval = BandwidthRateLimitInterval(this)

        internal fun correctErrors(): Builder {
            if (daysOfWeek == null) daysOfWeek = emptyList()
            if (endHourOfDay == null) endHourOfDay = 0
            if (endMinuteOfHour == null) endMinuteOfHour = 0
            if (startHourOfDay == null) startHourOfDay = 0
            if (startMinuteOfHour == null) startMinuteOfHour = 0
            return this
        }
    }
}
