// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * These are the details of the specified hypervisor. A hypervisor is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.
 */
public class HypervisorDetails private constructor(builder: Builder) {
    /**
     * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
     */
    public val host: kotlin.String? = builder.host
    /**
     * The Amazon Resource Name (ARN) of the hypervisor.
     */
    public val hypervisorArn: kotlin.String? = builder.hypervisorArn
    /**
     * The Amazon Resource Name (ARN) of the KMS used to encrypt the hypervisor.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * This is the time when the most recent successful sync of metadata occurred.
     */
    public val lastSuccessfulMetadataSyncTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulMetadataSyncTime
    /**
     * This is the most recent status for the indicated metadata sync.
     */
    public val latestMetadataSyncStatus: aws.sdk.kotlin.services.backupgateway.model.SyncMetadataStatus? = builder.latestMetadataSyncStatus
    /**
     * This is the most recent status for the indicated metadata sync.
     */
    public val latestMetadataSyncStatusMessage: kotlin.String? = builder.latestMetadataSyncStatusMessage
    /**
     * The Amazon Resource Name (ARN) of the group of gateways within the requested log.
     */
    public val logGroupArn: kotlin.String? = builder.logGroupArn
    /**
     * This is the name of the specified hypervisor.
     */
    public val name: kotlin.String? = builder.name
    /**
     * This is the current state of the specified hypervisor.
     *
     * The possible states are `PENDING`, `ONLINE`, `OFFLINE`, or `ERROR`.
     */
    public val state: aws.sdk.kotlin.services.backupgateway.model.HypervisorState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backupgateway.model.HypervisorDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HypervisorDetails(")
        append("host=$host,")
        append("hypervisorArn=$hypervisorArn,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("lastSuccessfulMetadataSyncTime=$lastSuccessfulMetadataSyncTime,")
        append("latestMetadataSyncStatus=$latestMetadataSyncStatus,")
        append("latestMetadataSyncStatusMessage=$latestMetadataSyncStatusMessage,")
        append("logGroupArn=$logGroupArn,")
        append("name=$name,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = host?.hashCode() ?: 0
        result = 31 * result + (hypervisorArn?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulMetadataSyncTime?.hashCode() ?: 0)
        result = 31 * result + (latestMetadataSyncStatus?.hashCode() ?: 0)
        result = 31 * result + (latestMetadataSyncStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (logGroupArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HypervisorDetails

        if (host != other.host) return false
        if (hypervisorArn != other.hypervisorArn) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (lastSuccessfulMetadataSyncTime != other.lastSuccessfulMetadataSyncTime) return false
        if (latestMetadataSyncStatus != other.latestMetadataSyncStatus) return false
        if (latestMetadataSyncStatusMessage != other.latestMetadataSyncStatusMessage) return false
        if (logGroupArn != other.logGroupArn) return false
        if (name != other.name) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backupgateway.model.HypervisorDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
         */
        public var host: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the hypervisor.
         */
        public var hypervisorArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS used to encrypt the hypervisor.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * This is the time when the most recent successful sync of metadata occurred.
         */
        public var lastSuccessfulMetadataSyncTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This is the most recent status for the indicated metadata sync.
         */
        public var latestMetadataSyncStatus: aws.sdk.kotlin.services.backupgateway.model.SyncMetadataStatus? = null
        /**
         * This is the most recent status for the indicated metadata sync.
         */
        public var latestMetadataSyncStatusMessage: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the group of gateways within the requested log.
         */
        public var logGroupArn: kotlin.String? = null
        /**
         * This is the name of the specified hypervisor.
         */
        public var name: kotlin.String? = null
        /**
         * This is the current state of the specified hypervisor.
         *
         * The possible states are `PENDING`, `ONLINE`, `OFFLINE`, or `ERROR`.
         */
        public var state: aws.sdk.kotlin.services.backupgateway.model.HypervisorState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backupgateway.model.HypervisorDetails) : this() {
            this.host = x.host
            this.hypervisorArn = x.hypervisorArn
            this.kmsKeyArn = x.kmsKeyArn
            this.lastSuccessfulMetadataSyncTime = x.lastSuccessfulMetadataSyncTime
            this.latestMetadataSyncStatus = x.latestMetadataSyncStatus
            this.latestMetadataSyncStatusMessage = x.latestMetadataSyncStatusMessage
            this.logGroupArn = x.logGroupArn
            this.name = x.name
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backupgateway.model.HypervisorDetails = HypervisorDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
