// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.backupgateway.auth.BackupGatewayAuthSchemeProvider
import aws.sdk.kotlin.services.backupgateway.auth.DefaultBackupGatewayAuthSchemeProvider
import aws.sdk.kotlin.services.backupgateway.endpoints.BackupGatewayEndpointParameters
import aws.sdk.kotlin.services.backupgateway.endpoints.BackupGatewayEndpointProvider
import aws.sdk.kotlin.services.backupgateway.endpoints.DefaultBackupGatewayEndpointProvider
import aws.sdk.kotlin.services.backupgateway.model.AssociateGatewayToServerRequest
import aws.sdk.kotlin.services.backupgateway.model.AssociateGatewayToServerResponse
import aws.sdk.kotlin.services.backupgateway.model.CreateGatewayRequest
import aws.sdk.kotlin.services.backupgateway.model.CreateGatewayResponse
import aws.sdk.kotlin.services.backupgateway.model.DeleteGatewayRequest
import aws.sdk.kotlin.services.backupgateway.model.DeleteGatewayResponse
import aws.sdk.kotlin.services.backupgateway.model.DeleteHypervisorRequest
import aws.sdk.kotlin.services.backupgateway.model.DeleteHypervisorResponse
import aws.sdk.kotlin.services.backupgateway.model.DisassociateGatewayFromServerRequest
import aws.sdk.kotlin.services.backupgateway.model.DisassociateGatewayFromServerResponse
import aws.sdk.kotlin.services.backupgateway.model.GetBandwidthRateLimitScheduleRequest
import aws.sdk.kotlin.services.backupgateway.model.GetBandwidthRateLimitScheduleResponse
import aws.sdk.kotlin.services.backupgateway.model.GetGatewayRequest
import aws.sdk.kotlin.services.backupgateway.model.GetGatewayResponse
import aws.sdk.kotlin.services.backupgateway.model.GetHypervisorPropertyMappingsRequest
import aws.sdk.kotlin.services.backupgateway.model.GetHypervisorPropertyMappingsResponse
import aws.sdk.kotlin.services.backupgateway.model.GetHypervisorRequest
import aws.sdk.kotlin.services.backupgateway.model.GetHypervisorResponse
import aws.sdk.kotlin.services.backupgateway.model.GetVirtualMachineRequest
import aws.sdk.kotlin.services.backupgateway.model.GetVirtualMachineResponse
import aws.sdk.kotlin.services.backupgateway.model.ImportHypervisorConfigurationRequest
import aws.sdk.kotlin.services.backupgateway.model.ImportHypervisorConfigurationResponse
import aws.sdk.kotlin.services.backupgateway.model.ListGatewaysRequest
import aws.sdk.kotlin.services.backupgateway.model.ListGatewaysResponse
import aws.sdk.kotlin.services.backupgateway.model.ListHypervisorsRequest
import aws.sdk.kotlin.services.backupgateway.model.ListHypervisorsResponse
import aws.sdk.kotlin.services.backupgateway.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.backupgateway.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.backupgateway.model.ListVirtualMachinesRequest
import aws.sdk.kotlin.services.backupgateway.model.ListVirtualMachinesResponse
import aws.sdk.kotlin.services.backupgateway.model.PutBandwidthRateLimitScheduleRequest
import aws.sdk.kotlin.services.backupgateway.model.PutBandwidthRateLimitScheduleResponse
import aws.sdk.kotlin.services.backupgateway.model.PutHypervisorPropertyMappingsRequest
import aws.sdk.kotlin.services.backupgateway.model.PutHypervisorPropertyMappingsResponse
import aws.sdk.kotlin.services.backupgateway.model.PutMaintenanceStartTimeRequest
import aws.sdk.kotlin.services.backupgateway.model.PutMaintenanceStartTimeResponse
import aws.sdk.kotlin.services.backupgateway.model.StartVirtualMachinesMetadataSyncRequest
import aws.sdk.kotlin.services.backupgateway.model.StartVirtualMachinesMetadataSyncResponse
import aws.sdk.kotlin.services.backupgateway.model.TagResourceRequest
import aws.sdk.kotlin.services.backupgateway.model.TagResourceResponse
import aws.sdk.kotlin.services.backupgateway.model.TestHypervisorConfigurationRequest
import aws.sdk.kotlin.services.backupgateway.model.TestHypervisorConfigurationResponse
import aws.sdk.kotlin.services.backupgateway.model.UntagResourceRequest
import aws.sdk.kotlin.services.backupgateway.model.UntagResourceResponse
import aws.sdk.kotlin.services.backupgateway.model.UpdateGatewayInformationRequest
import aws.sdk.kotlin.services.backupgateway.model.UpdateGatewayInformationResponse
import aws.sdk.kotlin.services.backupgateway.model.UpdateGatewaySoftwareNowRequest
import aws.sdk.kotlin.services.backupgateway.model.UpdateGatewaySoftwareNowResponse
import aws.sdk.kotlin.services.backupgateway.model.UpdateHypervisorRequest
import aws.sdk.kotlin.services.backupgateway.model.UpdateHypervisorResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Backup Gateway"
public const val SdkVersion: String = "0.34.4-beta"

/**
 * # Backup gateway
 * Backup gateway connects Backup to your hypervisor, so you can create, store, and restore backups of your virtual machines (VMs) anywhere, whether on-premises or in the VMware Cloud (VMC) on Amazon Web Services.
 *
 * Add on-premises resources by connecting to a hypervisor through a gateway. Backup will automatically discover the resources in your hypervisor.
 *
 * Use Backup to assign virtual or on-premises resources to a backup plan, or run on-demand backups. Once you have backed up your resources, you can view them and restore them like any resource supported by Backup.
 *
 * To download the Amazon Web Services software to get started, navigate to the Backup console, choose **Gateways**, then choose **Create gateway**.
 */
public interface BackupGatewayClient : SdkClient {
    /**
     * BackupGatewayClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, BackupGatewayClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.interceptors.add(0, ClockSkewInterceptor())
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "BackupGateway",
                "BACKUP_GATEWAY",
                "backup_gateway",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, BackupGatewayClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): BackupGatewayClient = DefaultBackupGatewayClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: BackupGatewayAuthSchemeProvider = builder.authSchemeProvider ?: DefaultBackupGatewayAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: BackupGatewayEndpointProvider = builder.endpointProvider ?: DefaultBackupGatewayEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Backup Gateway"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: BackupGatewayAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: BackupGatewayEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a backup gateway with your server. After you complete the association process, you can back up and restore your VMs through the gateway.
     */
    public suspend fun associateGatewayToServer(input: AssociateGatewayToServerRequest): AssociateGatewayToServerResponse

    /**
     * Creates a backup gateway. After you create a gateway, you can associate it with a server using the `AssociateGatewayToServer` operation.
     */
    public suspend fun createGateway(input: CreateGatewayRequest): CreateGatewayResponse

    /**
     * Deletes a backup gateway.
     */
    public suspend fun deleteGateway(input: DeleteGatewayRequest): DeleteGatewayResponse

    /**
     * Deletes a hypervisor.
     */
    public suspend fun deleteHypervisor(input: DeleteHypervisorRequest): DeleteHypervisorResponse

    /**
     * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway can no longer access the virtual machines on the server.
     */
    public suspend fun disassociateGatewayFromServer(input: DisassociateGatewayFromServerRequest): DisassociateGatewayFromServerResponse

    /**
     * Retrieves the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to get a gateway's bandwidth rate limit schedule.
     */
    public suspend fun getBandwidthRateLimitSchedule(input: GetBandwidthRateLimitScheduleRequest): GetBandwidthRateLimitScheduleResponse

    /**
     * By providing the ARN (Amazon Resource Name), this API returns the gateway.
     */
    public suspend fun getGateway(input: GetGatewayRequest): GetGatewayResponse

    /**
     * This action requests information about the specified hypervisor to which the gateway will connect. A hypervisor is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.
     */
    public suspend fun getHypervisor(input: GetHypervisorRequest): GetHypervisorResponse

    /**
     * This action retrieves the property mappings for the specified hypervisor. A hypervisor property mapping displays the relationship of entity properties available from the on-premises hypervisor to the properties available in Amazon Web Services.
     */
    public suspend fun getHypervisorPropertyMappings(input: GetHypervisorPropertyMappingsRequest): GetHypervisorPropertyMappingsResponse

    /**
     * By providing the ARN (Amazon Resource Name), this API returns the virtual machine.
     */
    public suspend fun getVirtualMachine(input: GetVirtualMachineRequest): GetVirtualMachineResponse

    /**
     * Connect to a hypervisor by importing its configuration.
     */
    public suspend fun importHypervisorConfiguration(input: ImportHypervisorConfigurationRequest): ImportHypervisorConfigurationResponse

    /**
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list is ordered by gateway Amazon Resource Name (ARN).
     */
    public suspend fun listGateways(input: ListGatewaysRequest = ListGatewaysRequest { }): ListGatewaysResponse

    /**
     * Lists your hypervisors.
     */
    public suspend fun listHypervisors(input: ListHypervisorsRequest = ListHypervisorsRequest { }): ListHypervisorsResponse

    /**
     * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists your virtual machines.
     */
    public suspend fun listVirtualMachines(input: ListVirtualMachinesRequest = ListVirtualMachinesRequest { }): ListVirtualMachinesResponse

    /**
     * This action sets the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have a bandwidth rate limit schedule, which means no bandwidth rate limiting is in effect. Use this to initiate a gateway's bandwidth rate limit schedule.
     */
    public suspend fun putBandwidthRateLimitSchedule(input: PutBandwidthRateLimitScheduleRequest): PutBandwidthRateLimitScheduleResponse

    /**
     * This action sets the property mappings for the specified hypervisor. A hypervisor property mapping displays the relationship of entity properties available from the on-premises hypervisor to the properties available in Amazon Web Services.
     */
    public suspend fun putHypervisorPropertyMappings(input: PutHypervisorPropertyMappingsRequest): PutHypervisorPropertyMappingsResponse

    /**
     * Set the maintenance start time for a gateway.
     */
    public suspend fun putMaintenanceStartTime(input: PutMaintenanceStartTimeRequest): PutMaintenanceStartTimeResponse

    /**
     * This action sends a request to sync metadata across the specified virtual machines.
     */
    public suspend fun startVirtualMachinesMetadataSync(input: StartVirtualMachinesMetadataSyncRequest): StartVirtualMachinesMetadataSyncResponse

    /**
     * Tag the resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources.
     */
    public suspend fun testHypervisorConfiguration(input: TestHypervisorConfigurationRequest): TestHypervisorConfigurationResponse

    /**
     * Removes tags from the resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in your request.
     */
    public suspend fun updateGatewayInformation(input: UpdateGatewayInformationRequest): UpdateGatewayInformationResponse

    /**
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
     *
     * When you make this request, you get a `200 OK` success response immediately. However, it might take some time for the update to complete.
     */
    public suspend fun updateGatewaySoftwareNow(input: UpdateGatewaySoftwareNowRequest): UpdateGatewaySoftwareNowResponse

    /**
     * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.
     */
    public suspend fun updateHypervisor(input: UpdateHypervisorRequest): UpdateHypervisorResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun BackupGatewayClient.withConfig(block: BackupGatewayClient.Config.Builder.() -> Unit): BackupGatewayClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultBackupGatewayClient(newConfig)
}

/**
 * Associates a backup gateway with your server. After you complete the association process, you can back up and restore your VMs through the gateway.
 */
public suspend inline fun BackupGatewayClient.associateGatewayToServer(crossinline block: AssociateGatewayToServerRequest.Builder.() -> Unit): AssociateGatewayToServerResponse = associateGatewayToServer(AssociateGatewayToServerRequest.Builder().apply(block).build())

/**
 * Creates a backup gateway. After you create a gateway, you can associate it with a server using the `AssociateGatewayToServer` operation.
 */
public suspend inline fun BackupGatewayClient.createGateway(crossinline block: CreateGatewayRequest.Builder.() -> Unit): CreateGatewayResponse = createGateway(CreateGatewayRequest.Builder().apply(block).build())

/**
 * Deletes a backup gateway.
 */
public suspend inline fun BackupGatewayClient.deleteGateway(crossinline block: DeleteGatewayRequest.Builder.() -> Unit): DeleteGatewayResponse = deleteGateway(DeleteGatewayRequest.Builder().apply(block).build())

/**
 * Deletes a hypervisor.
 */
public suspend inline fun BackupGatewayClient.deleteHypervisor(crossinline block: DeleteHypervisorRequest.Builder.() -> Unit): DeleteHypervisorResponse = deleteHypervisor(DeleteHypervisorRequest.Builder().apply(block).build())

/**
 * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway can no longer access the virtual machines on the server.
 */
public suspend inline fun BackupGatewayClient.disassociateGatewayFromServer(crossinline block: DisassociateGatewayFromServerRequest.Builder.() -> Unit): DisassociateGatewayFromServerResponse = disassociateGatewayFromServer(DisassociateGatewayFromServerRequest.Builder().apply(block).build())

/**
 * Retrieves the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to get a gateway's bandwidth rate limit schedule.
 */
public suspend inline fun BackupGatewayClient.getBandwidthRateLimitSchedule(crossinline block: GetBandwidthRateLimitScheduleRequest.Builder.() -> Unit): GetBandwidthRateLimitScheduleResponse = getBandwidthRateLimitSchedule(GetBandwidthRateLimitScheduleRequest.Builder().apply(block).build())

/**
 * By providing the ARN (Amazon Resource Name), this API returns the gateway.
 */
public suspend inline fun BackupGatewayClient.getGateway(crossinline block: GetGatewayRequest.Builder.() -> Unit): GetGatewayResponse = getGateway(GetGatewayRequest.Builder().apply(block).build())

/**
 * This action requests information about the specified hypervisor to which the gateway will connect. A hypervisor is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.
 */
public suspend inline fun BackupGatewayClient.getHypervisor(crossinline block: GetHypervisorRequest.Builder.() -> Unit): GetHypervisorResponse = getHypervisor(GetHypervisorRequest.Builder().apply(block).build())

/**
 * This action retrieves the property mappings for the specified hypervisor. A hypervisor property mapping displays the relationship of entity properties available from the on-premises hypervisor to the properties available in Amazon Web Services.
 */
public suspend inline fun BackupGatewayClient.getHypervisorPropertyMappings(crossinline block: GetHypervisorPropertyMappingsRequest.Builder.() -> Unit): GetHypervisorPropertyMappingsResponse = getHypervisorPropertyMappings(GetHypervisorPropertyMappingsRequest.Builder().apply(block).build())

/**
 * By providing the ARN (Amazon Resource Name), this API returns the virtual machine.
 */
public suspend inline fun BackupGatewayClient.getVirtualMachine(crossinline block: GetVirtualMachineRequest.Builder.() -> Unit): GetVirtualMachineResponse = getVirtualMachine(GetVirtualMachineRequest.Builder().apply(block).build())

/**
 * Connect to a hypervisor by importing its configuration.
 */
public suspend inline fun BackupGatewayClient.importHypervisorConfiguration(crossinline block: ImportHypervisorConfigurationRequest.Builder.() -> Unit): ImportHypervisorConfigurationResponse = importHypervisorConfiguration(ImportHypervisorConfigurationRequest.Builder().apply(block).build())

/**
 * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list is ordered by gateway Amazon Resource Name (ARN).
 */
public suspend inline fun BackupGatewayClient.listGateways(crossinline block: ListGatewaysRequest.Builder.() -> Unit): ListGatewaysResponse = listGateways(ListGatewaysRequest.Builder().apply(block).build())

/**
 * Lists your hypervisors.
 */
public suspend inline fun BackupGatewayClient.listHypervisors(crossinline block: ListHypervisorsRequest.Builder.() -> Unit): ListHypervisorsResponse = listHypervisors(ListHypervisorsRequest.Builder().apply(block).build())

/**
 * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
 */
public suspend inline fun BackupGatewayClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists your virtual machines.
 */
public suspend inline fun BackupGatewayClient.listVirtualMachines(crossinline block: ListVirtualMachinesRequest.Builder.() -> Unit): ListVirtualMachinesResponse = listVirtualMachines(ListVirtualMachinesRequest.Builder().apply(block).build())

/**
 * This action sets the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have a bandwidth rate limit schedule, which means no bandwidth rate limiting is in effect. Use this to initiate a gateway's bandwidth rate limit schedule.
 */
public suspend inline fun BackupGatewayClient.putBandwidthRateLimitSchedule(crossinline block: PutBandwidthRateLimitScheduleRequest.Builder.() -> Unit): PutBandwidthRateLimitScheduleResponse = putBandwidthRateLimitSchedule(PutBandwidthRateLimitScheduleRequest.Builder().apply(block).build())

/**
 * This action sets the property mappings for the specified hypervisor. A hypervisor property mapping displays the relationship of entity properties available from the on-premises hypervisor to the properties available in Amazon Web Services.
 */
public suspend inline fun BackupGatewayClient.putHypervisorPropertyMappings(crossinline block: PutHypervisorPropertyMappingsRequest.Builder.() -> Unit): PutHypervisorPropertyMappingsResponse = putHypervisorPropertyMappings(PutHypervisorPropertyMappingsRequest.Builder().apply(block).build())

/**
 * Set the maintenance start time for a gateway.
 */
public suspend inline fun BackupGatewayClient.putMaintenanceStartTime(crossinline block: PutMaintenanceStartTimeRequest.Builder.() -> Unit): PutMaintenanceStartTimeResponse = putMaintenanceStartTime(PutMaintenanceStartTimeRequest.Builder().apply(block).build())

/**
 * This action sends a request to sync metadata across the specified virtual machines.
 */
public suspend inline fun BackupGatewayClient.startVirtualMachinesMetadataSync(crossinline block: StartVirtualMachinesMetadataSyncRequest.Builder.() -> Unit): StartVirtualMachinesMetadataSyncResponse = startVirtualMachinesMetadataSync(StartVirtualMachinesMetadataSyncRequest.Builder().apply(block).build())

/**
 * Tag the resource.
 */
public suspend inline fun BackupGatewayClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources.
 */
public suspend inline fun BackupGatewayClient.testHypervisorConfiguration(crossinline block: TestHypervisorConfigurationRequest.Builder.() -> Unit): TestHypervisorConfigurationResponse = testHypervisorConfiguration(TestHypervisorConfigurationRequest.Builder().apply(block).build())

/**
 * Removes tags from the resource.
 */
public suspend inline fun BackupGatewayClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in your request.
 */
public suspend inline fun BackupGatewayClient.updateGatewayInformation(crossinline block: UpdateGatewayInformationRequest.Builder.() -> Unit): UpdateGatewayInformationResponse = updateGatewayInformation(UpdateGatewayInformationRequest.Builder().apply(block).build())

/**
 * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
 *
 * When you make this request, you get a `200 OK` success response immediately. However, it might take some time for the update to complete.
 */
public suspend inline fun BackupGatewayClient.updateGatewaySoftwareNow(crossinline block: UpdateGatewaySoftwareNowRequest.Builder.() -> Unit): UpdateGatewaySoftwareNowResponse = updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest.Builder().apply(block).build())

/**
 * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.
 */
public suspend inline fun BackupGatewayClient.updateHypervisor(crossinline block: UpdateHypervisorRequest.Builder.() -> Unit): UpdateHypervisorResponse = updateHypervisor(UpdateHypervisorRequest.Builder().apply(block).build())
