// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.backupgateway.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.backupgateway.model.*
import aws.sdk.kotlin.services.backupgateway.model.AssociateGatewayToServerRequest
import aws.sdk.kotlin.services.backupgateway.model.AssociateGatewayToServerResponse
import aws.sdk.kotlin.services.backupgateway.model.CreateGatewayRequest
import aws.sdk.kotlin.services.backupgateway.model.CreateGatewayResponse
import aws.sdk.kotlin.services.backupgateway.model.DeleteGatewayRequest
import aws.sdk.kotlin.services.backupgateway.model.DeleteGatewayResponse
import aws.sdk.kotlin.services.backupgateway.model.DeleteHypervisorRequest
import aws.sdk.kotlin.services.backupgateway.model.DeleteHypervisorResponse
import aws.sdk.kotlin.services.backupgateway.model.DisassociateGatewayFromServerRequest
import aws.sdk.kotlin.services.backupgateway.model.DisassociateGatewayFromServerResponse
import aws.sdk.kotlin.services.backupgateway.model.GetGatewayRequest
import aws.sdk.kotlin.services.backupgateway.model.GetGatewayResponse
import aws.sdk.kotlin.services.backupgateway.model.GetVirtualMachineRequest
import aws.sdk.kotlin.services.backupgateway.model.GetVirtualMachineResponse
import aws.sdk.kotlin.services.backupgateway.model.ImportHypervisorConfigurationRequest
import aws.sdk.kotlin.services.backupgateway.model.ImportHypervisorConfigurationResponse
import aws.sdk.kotlin.services.backupgateway.model.ListGatewaysRequest
import aws.sdk.kotlin.services.backupgateway.model.ListGatewaysResponse
import aws.sdk.kotlin.services.backupgateway.model.ListHypervisorsRequest
import aws.sdk.kotlin.services.backupgateway.model.ListHypervisorsResponse
import aws.sdk.kotlin.services.backupgateway.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.backupgateway.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.backupgateway.model.ListVirtualMachinesRequest
import aws.sdk.kotlin.services.backupgateway.model.ListVirtualMachinesResponse
import aws.sdk.kotlin.services.backupgateway.model.PutMaintenanceStartTimeRequest
import aws.sdk.kotlin.services.backupgateway.model.PutMaintenanceStartTimeResponse
import aws.sdk.kotlin.services.backupgateway.model.TagResourceRequest
import aws.sdk.kotlin.services.backupgateway.model.TagResourceResponse
import aws.sdk.kotlin.services.backupgateway.model.TestHypervisorConfigurationRequest
import aws.sdk.kotlin.services.backupgateway.model.TestHypervisorConfigurationResponse
import aws.sdk.kotlin.services.backupgateway.model.UntagResourceRequest
import aws.sdk.kotlin.services.backupgateway.model.UntagResourceResponse
import aws.sdk.kotlin.services.backupgateway.model.UpdateGatewayInformationRequest
import aws.sdk.kotlin.services.backupgateway.model.UpdateGatewayInformationResponse
import aws.sdk.kotlin.services.backupgateway.model.UpdateGatewaySoftwareNowRequest
import aws.sdk.kotlin.services.backupgateway.model.UpdateGatewaySoftwareNowResponse
import aws.sdk.kotlin.services.backupgateway.model.UpdateHypervisorRequest
import aws.sdk.kotlin.services.backupgateway.model.UpdateHypervisorResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Backup gateway
 * Backup gateway connects Backup to your hypervisor, so you can create, store, and restore backups of your virtual machines (VMs) anywhere, whether on-premises or in the VMware Cloud (VMC) on Amazon Web Services.
 *
 * Add on-premises resources by connecting to a hypervisor through a gateway. Backup will automatically discover the resources in your hypervisor.
 *
 * Use Backup to assign virtual or on-premises resources to a backup plan, or run on-demand backups. Once you have backed up your resources, you can view them and restore them like any resource supported by Backup.
 *
 * To download the Amazon Web Services software to get started, navigate to the Backup console, choose **Gateways**, then choose **Create gateway**.
 */
public interface BackupGatewayClient : SdkClient {

    override val serviceName: String
        get() = "Backup Gateway"
    /**
     * BackupGatewayClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): BackupGatewayClient {
            val config = Config.Builder().apply(block).build()
            return DefaultBackupGatewayClient(config)
        }

        public operator fun invoke(config: Config): BackupGatewayClient = DefaultBackupGatewayClient(config)

        /**
         * Construct a [BackupGatewayClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): BackupGatewayClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultBackupGatewayClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a backup gateway with your server. After you complete the association process, you can back up and restore your VMs through the gateway.
     */
    public suspend fun associateGatewayToServer(input: AssociateGatewayToServerRequest): AssociateGatewayToServerResponse

    /**
     * Creates a backup gateway. After you create a gateway, you can associate it with a server using the `AssociateGatewayToServer` operation.
     */
    public suspend fun createGateway(input: CreateGatewayRequest): CreateGatewayResponse

    /**
     * Deletes a backup gateway.
     */
    public suspend fun deleteGateway(input: DeleteGatewayRequest): DeleteGatewayResponse

    /**
     * Deletes a hypervisor.
     */
    public suspend fun deleteHypervisor(input: DeleteHypervisorRequest): DeleteHypervisorResponse

    /**
     * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway can no longer access the virtual machines on the server.
     */
    public suspend fun disassociateGatewayFromServer(input: DisassociateGatewayFromServerRequest): DisassociateGatewayFromServerResponse

    /**
     * By providing the ARN (Amazon Resource Name), this API returns the gateway.
     */
    public suspend fun getGateway(input: GetGatewayRequest): GetGatewayResponse

    /**
     * By providing the ARN (Amazon Resource Name), this API returns the virtual machine.
     */
    public suspend fun getVirtualMachine(input: GetVirtualMachineRequest): GetVirtualMachineResponse

    /**
     * Connect to a hypervisor by importing its configuration.
     */
    public suspend fun importHypervisorConfiguration(input: ImportHypervisorConfigurationRequest): ImportHypervisorConfigurationResponse

    /**
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list is ordered by gateway Amazon Resource Name (ARN).
     */
    public suspend fun listGateways(input: ListGatewaysRequest = ListGatewaysRequest {}): ListGatewaysResponse

    /**
     * Lists your hypervisors.
     */
    public suspend fun listHypervisors(input: ListHypervisorsRequest = ListHypervisorsRequest {}): ListHypervisorsResponse

    /**
     * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists your virtual machines.
     */
    public suspend fun listVirtualMachines(input: ListVirtualMachinesRequest = ListVirtualMachinesRequest {}): ListVirtualMachinesResponse

    /**
     * Set the maintenance start time for a gateway.
     */
    public suspend fun putMaintenanceStartTime(input: PutMaintenanceStartTimeRequest): PutMaintenanceStartTimeResponse

    /**
     * Tag the resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources.
     */
    public suspend fun testHypervisorConfiguration(input: TestHypervisorConfigurationRequest): TestHypervisorConfigurationResponse

    /**
     * Removes tags from the resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in your request.
     */
    public suspend fun updateGatewayInformation(input: UpdateGatewayInformationRequest): UpdateGatewayInformationResponse

    /**
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
     *
     * When you make this request, you get a `200 OK` success response immediately. However, it might take some time for the update to complete.
     */
    public suspend fun updateGatewaySoftwareNow(input: UpdateGatewaySoftwareNowRequest): UpdateGatewaySoftwareNowResponse

    /**
     * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.
     */
    public suspend fun updateHypervisor(input: UpdateHypervisorRequest): UpdateHypervisorResponse
}

/**
 * Associates a backup gateway with your server. After you complete the association process, you can back up and restore your VMs through the gateway.
 */
public suspend inline fun BackupGatewayClient.associateGatewayToServer(crossinline block: AssociateGatewayToServerRequest.Builder.() -> Unit): AssociateGatewayToServerResponse = associateGatewayToServer(AssociateGatewayToServerRequest.Builder().apply(block).build())

/**
 * Creates a backup gateway. After you create a gateway, you can associate it with a server using the `AssociateGatewayToServer` operation.
 */
public suspend inline fun BackupGatewayClient.createGateway(crossinline block: CreateGatewayRequest.Builder.() -> Unit): CreateGatewayResponse = createGateway(CreateGatewayRequest.Builder().apply(block).build())

/**
 * Deletes a backup gateway.
 */
public suspend inline fun BackupGatewayClient.deleteGateway(crossinline block: DeleteGatewayRequest.Builder.() -> Unit): DeleteGatewayResponse = deleteGateway(DeleteGatewayRequest.Builder().apply(block).build())

/**
 * Deletes a hypervisor.
 */
public suspend inline fun BackupGatewayClient.deleteHypervisor(crossinline block: DeleteHypervisorRequest.Builder.() -> Unit): DeleteHypervisorResponse = deleteHypervisor(DeleteHypervisorRequest.Builder().apply(block).build())

/**
 * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway can no longer access the virtual machines on the server.
 */
public suspend inline fun BackupGatewayClient.disassociateGatewayFromServer(crossinline block: DisassociateGatewayFromServerRequest.Builder.() -> Unit): DisassociateGatewayFromServerResponse = disassociateGatewayFromServer(DisassociateGatewayFromServerRequest.Builder().apply(block).build())

/**
 * By providing the ARN (Amazon Resource Name), this API returns the gateway.
 */
public suspend inline fun BackupGatewayClient.getGateway(crossinline block: GetGatewayRequest.Builder.() -> Unit): GetGatewayResponse = getGateway(GetGatewayRequest.Builder().apply(block).build())

/**
 * By providing the ARN (Amazon Resource Name), this API returns the virtual machine.
 */
public suspend inline fun BackupGatewayClient.getVirtualMachine(crossinline block: GetVirtualMachineRequest.Builder.() -> Unit): GetVirtualMachineResponse = getVirtualMachine(GetVirtualMachineRequest.Builder().apply(block).build())

/**
 * Connect to a hypervisor by importing its configuration.
 */
public suspend inline fun BackupGatewayClient.importHypervisorConfiguration(crossinline block: ImportHypervisorConfigurationRequest.Builder.() -> Unit): ImportHypervisorConfigurationResponse = importHypervisorConfiguration(ImportHypervisorConfigurationRequest.Builder().apply(block).build())

/**
 * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list is ordered by gateway Amazon Resource Name (ARN).
 */
public suspend inline fun BackupGatewayClient.listGateways(crossinline block: ListGatewaysRequest.Builder.() -> Unit): ListGatewaysResponse = listGateways(ListGatewaysRequest.Builder().apply(block).build())

/**
 * Lists your hypervisors.
 */
public suspend inline fun BackupGatewayClient.listHypervisors(crossinline block: ListHypervisorsRequest.Builder.() -> Unit): ListHypervisorsResponse = listHypervisors(ListHypervisorsRequest.Builder().apply(block).build())

/**
 * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
 */
public suspend inline fun BackupGatewayClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists your virtual machines.
 */
public suspend inline fun BackupGatewayClient.listVirtualMachines(crossinline block: ListVirtualMachinesRequest.Builder.() -> Unit): ListVirtualMachinesResponse = listVirtualMachines(ListVirtualMachinesRequest.Builder().apply(block).build())

/**
 * Set the maintenance start time for a gateway.
 */
public suspend inline fun BackupGatewayClient.putMaintenanceStartTime(crossinline block: PutMaintenanceStartTimeRequest.Builder.() -> Unit): PutMaintenanceStartTimeResponse = putMaintenanceStartTime(PutMaintenanceStartTimeRequest.Builder().apply(block).build())

/**
 * Tag the resource.
 */
public suspend inline fun BackupGatewayClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources.
 */
public suspend inline fun BackupGatewayClient.testHypervisorConfiguration(crossinline block: TestHypervisorConfigurationRequest.Builder.() -> Unit): TestHypervisorConfigurationResponse = testHypervisorConfiguration(TestHypervisorConfigurationRequest.Builder().apply(block).build())

/**
 * Removes tags from the resource.
 */
public suspend inline fun BackupGatewayClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in your request.
 */
public suspend inline fun BackupGatewayClient.updateGatewayInformation(crossinline block: UpdateGatewayInformationRequest.Builder.() -> Unit): UpdateGatewayInformationResponse = updateGatewayInformation(UpdateGatewayInformationRequest.Builder().apply(block).build())

/**
 * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
 *
 * When you make this request, you get a `200 OK` success response immediately. However, it might take some time for the update to complete.
 */
public suspend inline fun BackupGatewayClient.updateGatewaySoftwareNow(crossinline block: UpdateGatewaySoftwareNowRequest.Builder.() -> Unit): UpdateGatewaySoftwareNowResponse = updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest.Builder().apply(block).build())

/**
 * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.
 */
public suspend inline fun BackupGatewayClient.updateHypervisor(crossinline block: UpdateHypervisorRequest.Builder.() -> Unit): UpdateHypervisorResponse = updateHypervisor(UpdateHypervisorRequest.Builder().apply(block).build())
