// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of gateway.
 */
class GatewayDetails private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the `ListGateways` operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The display name of the gateway.
     */
    val gatewayDisplayName: kotlin.String? = builder.gatewayDisplayName
    /**
     * The type of the gateway type.
     */
    val gatewayType: aws.sdk.kotlin.services.backupgateway.model.GatewayType? = builder.gatewayType
    /**
     * The hypervisor ID of the gateway.
     */
    val hypervisorId: kotlin.String? = builder.hypervisorId
    /**
     * Details showing the last time Backup gateway communicated with the cloud, in Unix format and UTC time.
     */
    val lastSeenTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSeenTime
    /**
     * Details showing the next update availability time of the gateway.
     */
    val nextUpdateAvailabilityTime: aws.smithy.kotlin.runtime.time.Instant? = builder.nextUpdateAvailabilityTime
    /**
     * The DNS name for the virtual private cloud (VPC) endpoint the gateway uses to connect to the cloud for backup gateway.
     */
    val vpcEndpoint: kotlin.String? = builder.vpcEndpoint

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backupgateway.model.GatewayDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GatewayDetails(")
        append("gatewayArn=$gatewayArn,")
        append("gatewayDisplayName=$gatewayDisplayName,")
        append("gatewayType=$gatewayType,")
        append("hypervisorId=$hypervisorId,")
        append("lastSeenTime=$lastSeenTime,")
        append("nextUpdateAvailabilityTime=$nextUpdateAvailabilityTime,")
        append("vpcEndpoint=$vpcEndpoint)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (gatewayDisplayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayType?.hashCode() ?: 0)
        result = 31 * result + (hypervisorId?.hashCode() ?: 0)
        result = 31 * result + (lastSeenTime?.hashCode() ?: 0)
        result = 31 * result + (nextUpdateAvailabilityTime?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GatewayDetails

        if (gatewayArn != other.gatewayArn) return false
        if (gatewayDisplayName != other.gatewayDisplayName) return false
        if (gatewayType != other.gatewayType) return false
        if (hypervisorId != other.hypervisorId) return false
        if (lastSeenTime != other.lastSeenTime) return false
        if (nextUpdateAvailabilityTime != other.nextUpdateAvailabilityTime) return false
        if (vpcEndpoint != other.vpcEndpoint) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backupgateway.model.GatewayDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the `ListGateways` operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        var gatewayArn: kotlin.String? = null
        /**
         * The display name of the gateway.
         */
        var gatewayDisplayName: kotlin.String? = null
        /**
         * The type of the gateway type.
         */
        var gatewayType: aws.sdk.kotlin.services.backupgateway.model.GatewayType? = null
        /**
         * The hypervisor ID of the gateway.
         */
        var hypervisorId: kotlin.String? = null
        /**
         * Details showing the last time Backup gateway communicated with the cloud, in Unix format and UTC time.
         */
        var lastSeenTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details showing the next update availability time of the gateway.
         */
        var nextUpdateAvailabilityTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DNS name for the virtual private cloud (VPC) endpoint the gateway uses to connect to the cloud for backup gateway.
         */
        var vpcEndpoint: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backupgateway.model.GatewayDetails) : this() {
            this.gatewayArn = x.gatewayArn
            this.gatewayDisplayName = x.gatewayDisplayName
            this.gatewayType = x.gatewayType
            this.hypervisorId = x.hypervisorId
            this.lastSeenTime = x.lastSeenTime
            this.nextUpdateAvailabilityTime = x.nextUpdateAvailabilityTime
            this.vpcEndpoint = x.vpcEndpoint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backupgateway.model.GatewayDetails = GatewayDetails(this)
    }
}
