// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backup.model.AdvancedBackupSetting
import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.UpdateBackupPlanResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateBackupPlanOperationDeserializer: HttpDeserialize<UpdateBackupPlanResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateBackupPlanResponse {
        if (!response.status.isSuccess()) {
            throwUpdateBackupPlanError(context, response)
        }
        val builder = UpdateBackupPlanResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateBackupPlanOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateBackupPlanError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateBackupPlanOperationBody(builder: UpdateBackupPlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADVANCEDBACKUPSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdvancedBackupSettings"))
    val BACKUPPLANARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupPlanArn"))
    val BACKUPPLANID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupPlanId"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val VERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADVANCEDBACKUPSETTINGS_DESCRIPTOR)
        field(BACKUPPLANARN_DESCRIPTOR)
        field(BACKUPPLANID_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(VERSIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADVANCEDBACKUPSETTINGS_DESCRIPTOR.index -> builder.advancedBackupSettings =
                    deserializer.deserializeList(ADVANCEDBACKUPSETTINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<AdvancedBackupSetting>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAdvancedBackupSettingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BACKUPPLANARN_DESCRIPTOR.index -> builder.backupPlanArn = deserializeString()
                BACKUPPLANID_DESCRIPTOR.index -> builder.backupPlanId = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                VERSIONID_DESCRIPTOR.index -> builder.versionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
