// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.DescribeBackupVaultResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeBackupVaultOperationDeserializer: HttpDeserialize<DescribeBackupVaultResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeBackupVaultResponse {
        if (!response.status.isSuccess()) {
            throwDescribeBackupVaultError(context, response)
        }
        val builder = DescribeBackupVaultResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeBackupVaultOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeBackupVaultError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBackupVaultOperationBody(builder: DescribeBackupVaultResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultArn"))
    val BACKUPVAULTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultName"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val CREATORREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatorRequestId"))
    val ENCRYPTIONKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EncryptionKeyArn"))
    val LOCKDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LockDate"))
    val LOCKED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Locked"))
    val MAXRETENTIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("MaxRetentionDays"))
    val MINRETENTIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("MinRetentionDays"))
    val NUMBEROFRECOVERYPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfRecoveryPoints"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPVAULTARN_DESCRIPTOR)
        field(BACKUPVAULTNAME_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(CREATORREQUESTID_DESCRIPTOR)
        field(ENCRYPTIONKEYARN_DESCRIPTOR)
        field(LOCKDATE_DESCRIPTOR)
        field(LOCKED_DESCRIPTOR)
        field(MAXRETENTIONDAYS_DESCRIPTOR)
        field(MINRETENTIONDAYS_DESCRIPTOR)
        field(NUMBEROFRECOVERYPOINTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPVAULTARN_DESCRIPTOR.index -> builder.backupVaultArn = deserializeString()
                BACKUPVAULTNAME_DESCRIPTOR.index -> builder.backupVaultName = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATORREQUESTID_DESCRIPTOR.index -> builder.creatorRequestId = deserializeString()
                ENCRYPTIONKEYARN_DESCRIPTOR.index -> builder.encryptionKeyArn = deserializeString()
                LOCKDATE_DESCRIPTOR.index -> builder.lockDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOCKED_DESCRIPTOR.index -> builder.locked = deserializeBoolean()
                MAXRETENTIONDAYS_DESCRIPTOR.index -> builder.maxRetentionDays = deserializeLong()
                MINRETENTIONDAYS_DESCRIPTOR.index -> builder.minRetentionDays = deserializeLong()
                NUMBEROFRECOVERYPOINTS_DESCRIPTOR.index -> builder.numberOfRecoveryPoints = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
