// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



public class StartBackupJobRequest private constructor(builder: Builder) {
    /**
     * Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.
     *
     * Valid values: Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup. Set to `"WindowsVSS""disabled"` to create a regular backup. The `WindowsVSS` option is not enabled by default.
     */
    public val backupOptions: Map<String, String>? = builder.backupOptions
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * A value in minutes during which a successfully started backup must complete, or else Backup will cancel the job. This value is optional. This value begins counting down from when the backup was scheduled. It does not add additional time for `StartWindowMinutes`, or if the backup started later than scheduled.
     */
    public val completeWindowMinutes: kotlin.Long? = builder.completeWindowMinutes
    /**
     * Specifies the IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to `StartBackupJob`. Retrying a successful request with the same idempotency token results in a success message with no action taken.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup will transition and expire backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     */
    public val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle
    /**
     * To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair.
     */
    public val recoveryPointTags: Map<String, String>? = builder.recoveryPointTags
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional, and the default is 8 hours.
     */
    public val startWindowMinutes: kotlin.Long? = builder.startWindowMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.StartBackupJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartBackupJobRequest(")
        append("backupOptions=$backupOptions,")
        append("backupVaultName=$backupVaultName,")
        append("completeWindowMinutes=$completeWindowMinutes,")
        append("iamRoleArn=$iamRoleArn,")
        append("idempotencyToken=$idempotencyToken,")
        append("lifecycle=$lifecycle,")
        append("recoveryPointTags=*** Sensitive Data Redacted ***,")
        append("resourceArn=$resourceArn,")
        append("startWindowMinutes=$startWindowMinutes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupOptions?.hashCode() ?: 0
        result = 31 * result + (backupVaultName?.hashCode() ?: 0)
        result = 31 * result + (completeWindowMinutes?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointTags?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (startWindowMinutes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartBackupJobRequest

        if (backupOptions != other.backupOptions) return false
        if (backupVaultName != other.backupVaultName) return false
        if (completeWindowMinutes != other.completeWindowMinutes) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (lifecycle != other.lifecycle) return false
        if (recoveryPointTags != other.recoveryPointTags) return false
        if (resourceArn != other.resourceArn) return false
        if (startWindowMinutes != other.startWindowMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.StartBackupJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.
         *
         * Valid values: Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup. Set to `"WindowsVSS""disabled"` to create a regular backup. The `WindowsVSS` option is not enabled by default.
         */
        public var backupOptions: Map<String, String>? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * A value in minutes during which a successfully started backup must complete, or else Backup will cancel the job. This value is optional. This value begins counting down from when the backup was scheduled. It does not add additional time for `StartWindowMinutes`, or if the backup started later than scheduled.
         */
        public var completeWindowMinutes: kotlin.Long? = null
        /**
         * Specifies the IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to `StartBackupJob`. Retrying a successful request with the same idempotency token results in a success message with no action taken.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup will transition and expire backups automatically according to the lifecycle that you define.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         *
         * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
         */
        public var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null
        /**
         * To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair.
         */
        public var recoveryPointTags: Map<String, String>? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional, and the default is 8 hours.
         */
        public var startWindowMinutes: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.StartBackupJobRequest) : this() {
            this.backupOptions = x.backupOptions
            this.backupVaultName = x.backupVaultName
            this.completeWindowMinutes = x.completeWindowMinutes
            this.iamRoleArn = x.iamRoleArn
            this.idempotencyToken = x.idempotencyToken
            this.lifecycle = x.lifecycle
            this.recoveryPointTags = x.recoveryPointTags
            this.resourceArn = x.resourceArn
            this.startWindowMinutes = x.startWindowMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.StartBackupJobRequest = StartBackupJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }
    }
}
