// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

public class ListRecoveryPointsByBackupVaultRequest private constructor(builder: Builder) {
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     *
     * Backup vault name might not be available when a supported service creates the backup.
     */
    public val backupVaultName: kotlin.String? = requireNotNull(builder.backupVaultName) { "A non-null value must be provided for backupVaultName" }
    /**
     * Returns only recovery points that match the specified backup plan ID.
     */
    public val byBackupPlanId: kotlin.String? = builder.byBackupPlanId
    /**
     * Returns only recovery points that were created after the specified timestamp.
     */
    public val byCreatedAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.byCreatedAfter
    /**
     * Returns only recovery points that were created before the specified timestamp.
     */
    public val byCreatedBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.byCreatedBefore
    /**
     * Returns only recovery points that match the specified resource Amazon Resource Name (ARN).
     */
    public val byResourceArn: kotlin.String? = builder.byResourceArn
    /**
     * Returns only recovery points that match the specified resource type.
     */
    public val byResourceType: kotlin.String? = builder.byResourceType
    /**
     * The maximum number of items to be returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The next item following a partial list of returned items. For example, if a request is made to return `maxResults` number of items, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRecoveryPointsByBackupVaultRequest(")
        append("backupVaultName=$backupVaultName,")
        append("byBackupPlanId=$byBackupPlanId,")
        append("byCreatedAfter=$byCreatedAfter,")
        append("byCreatedBefore=$byCreatedBefore,")
        append("byResourceArn=$byResourceArn,")
        append("byResourceType=$byResourceType,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultName?.hashCode() ?: 0
        result = 31 * result + (byBackupPlanId?.hashCode() ?: 0)
        result = 31 * result + (byCreatedAfter?.hashCode() ?: 0)
        result = 31 * result + (byCreatedBefore?.hashCode() ?: 0)
        result = 31 * result + (byResourceArn?.hashCode() ?: 0)
        result = 31 * result + (byResourceType?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRecoveryPointsByBackupVaultRequest

        if (backupVaultName != other.backupVaultName) return false
        if (byBackupPlanId != other.byBackupPlanId) return false
        if (byCreatedAfter != other.byCreatedAfter) return false
        if (byCreatedBefore != other.byCreatedBefore) return false
        if (byResourceArn != other.byResourceArn) return false
        if (byResourceType != other.byResourceType) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         *
         * Backup vault name might not be available when a supported service creates the backup.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * Returns only recovery points that match the specified backup plan ID.
         */
        public var byBackupPlanId: kotlin.String? = null
        /**
         * Returns only recovery points that were created after the specified timestamp.
         */
        public var byCreatedAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only recovery points that were created before the specified timestamp.
         */
        public var byCreatedBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only recovery points that match the specified resource Amazon Resource Name (ARN).
         */
        public var byResourceArn: kotlin.String? = null
        /**
         * Returns only recovery points that match the specified resource type.
         */
        public var byResourceType: kotlin.String? = null
        /**
         * The maximum number of items to be returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The next item following a partial list of returned items. For example, if a request is made to return `maxResults` number of items, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest) : this() {
            this.backupVaultName = x.backupVaultName
            this.byBackupPlanId = x.byBackupPlanId
            this.byCreatedAfter = x.byCreatedAfter
            this.byCreatedBefore = x.byCreatedBefore
            this.byResourceArn = x.byResourceArn
            this.byResourceType = x.byResourceType
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest = ListRecoveryPointsByBackupVaultRequest(this)
    }
}
