// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeRestoreJobResponse private constructor(builder: Builder) {
    /**
     * Returns the account ID that owns the restore job.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The size, in bytes, of the restored resource.
     */
    public val backupSizeInBytes: kotlin.Long? = builder.backupSizeInBytes
    /**
     * The date and time that a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val completionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.completionDate
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a resource whose recovery point is being restored. The format of the ARN depends on the resource type of the backed-up resource.
     */
    public val createdResourceArn: kotlin.String? = builder.createdResourceArn
    /**
     * The date and time that a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The amount of time in minutes that a job restoring a recovery point is expected to take.
     */
    public val expectedCompletionTimeMinutes: kotlin.Long? = builder.expectedCompletionTimeMinutes
    /**
     * Specifies the IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * Contains an estimated percentage that is complete of a job at the time the job status was queried.
     */
    public val percentDone: kotlin.String? = builder.percentDone
    /**
     * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * Returns metadata associated with a restore job listed by resource type.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * Uniquely identifies the job that restores a recovery point.
     */
    public val restoreJobId: kotlin.String? = builder.restoreJobId
    /**
     * Status code specifying the state of the job that is initiated by Backup to restore a recovery point.
     */
    public val status: aws.sdk.kotlin.services.backup.model.RestoreJobStatus? = builder.status
    /**
     * A message showing the status of a job to restore a recovery point.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.DescribeRestoreJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRestoreJobResponse(")
        append("accountId=$accountId,")
        append("backupSizeInBytes=$backupSizeInBytes,")
        append("completionDate=$completionDate,")
        append("createdResourceArn=$createdResourceArn,")
        append("creationDate=$creationDate,")
        append("expectedCompletionTimeMinutes=$expectedCompletionTimeMinutes,")
        append("iamRoleArn=$iamRoleArn,")
        append("percentDone=$percentDone,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("resourceType=$resourceType,")
        append("restoreJobId=$restoreJobId,")
        append("status=$status,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (backupSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (completionDate?.hashCode() ?: 0)
        result = 31 * result + (createdResourceArn?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (expectedCompletionTimeMinutes?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (percentDone?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (restoreJobId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRestoreJobResponse

        if (accountId != other.accountId) return false
        if (backupSizeInBytes != other.backupSizeInBytes) return false
        if (completionDate != other.completionDate) return false
        if (createdResourceArn != other.createdResourceArn) return false
        if (creationDate != other.creationDate) return false
        if (expectedCompletionTimeMinutes != other.expectedCompletionTimeMinutes) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (percentDone != other.percentDone) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (resourceType != other.resourceType) return false
        if (restoreJobId != other.restoreJobId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.DescribeRestoreJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Returns the account ID that owns the restore job.
         */
        public var accountId: kotlin.String? = null
        /**
         * The size, in bytes, of the restored resource.
         */
        public var backupSizeInBytes: kotlin.Long? = null
        /**
         * The date and time that a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var completionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a resource whose recovery point is being restored. The format of the ARN depends on the resource type of the backed-up resource.
         */
        public var createdResourceArn: kotlin.String? = null
        /**
         * The date and time that a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The amount of time in minutes that a job restoring a recovery point is expected to take.
         */
        public var expectedCompletionTimeMinutes: kotlin.Long? = null
        /**
         * Specifies the IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * Contains an estimated percentage that is complete of a job at the time the job status was queried.
         */
        public var percentDone: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * Returns metadata associated with a restore job listed by resource type.
         */
        public var resourceType: kotlin.String? = null
        /**
         * Uniquely identifies the job that restores a recovery point.
         */
        public var restoreJobId: kotlin.String? = null
        /**
         * Status code specifying the state of the job that is initiated by Backup to restore a recovery point.
         */
        public var status: aws.sdk.kotlin.services.backup.model.RestoreJobStatus? = null
        /**
         * A message showing the status of a job to restore a recovery point.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.DescribeRestoreJobResponse) : this() {
            this.accountId = x.accountId
            this.backupSizeInBytes = x.backupSizeInBytes
            this.completionDate = x.completionDate
            this.createdResourceArn = x.createdResourceArn
            this.creationDate = x.creationDate
            this.expectedCompletionTimeMinutes = x.expectedCompletionTimeMinutes
            this.iamRoleArn = x.iamRoleArn
            this.percentDone = x.percentDone
            this.recoveryPointArn = x.recoveryPointArn
            this.resourceType = x.resourceType
            this.restoreJobId = x.restoreJobId
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.DescribeRestoreJobResponse = DescribeRestoreJobResponse(this)
    }
}
