// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * A list of backup options for each resource type.
 */
public class AdvancedBackupSetting private constructor(builder: Builder) {
    /**
     * Specifies the backup option for a selected resource. This option is only available for Windows VSS backup jobs.
     *
     * Valid values:
     *
     * Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup.
     *
     * Set to `"WindowsVSS":"disabled"` to create a regular backup. The `WindowsVSS` option is not enabled by default.
     *
     * If you specify an invalid option, you get an `InvalidParameterValueException` exception.
     *
     * For more information about Windows VSS backups, see [Creating a VSS-Enabled Windows Backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html).
     */
    public val backupOptions: Map<String, String>? = builder.backupOptions
    /**
     * Specifies an object containing resource type and backup options. The only supported resource type is Amazon EC2 instances with Windows Volume Shadow Copy Service (VSS). For a CloudFormation example, see the [sample CloudFormation template to enable Windows VSS](https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html) in the *Backup User Guide*.
     *
     * Valid values: `EC2`.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.AdvancedBackupSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedBackupSetting(")
        append("backupOptions=$backupOptions,")
        append("resourceType=$resourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupOptions?.hashCode() ?: 0
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedBackupSetting

        if (backupOptions != other.backupOptions) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.AdvancedBackupSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the backup option for a selected resource. This option is only available for Windows VSS backup jobs.
         *
         * Valid values:
         *
         * Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup.
         *
         * Set to `"WindowsVSS":"disabled"` to create a regular backup. The `WindowsVSS` option is not enabled by default.
         *
         * If you specify an invalid option, you get an `InvalidParameterValueException` exception.
         *
         * For more information about Windows VSS backups, see [Creating a VSS-Enabled Windows Backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html).
         */
        public var backupOptions: Map<String, String>? = null
        /**
         * Specifies an object containing resource type and backup options. The only supported resource type is Amazon EC2 instances with Windows Volume Shadow Copy Service (VSS). For a CloudFormation example, see the [sample CloudFormation template to enable Windows VSS](https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html) in the *Backup User Guide*.
         *
         * Valid values: `EC2`.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.AdvancedBackupSetting) : this() {
            this.backupOptions = x.backupOptions
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.AdvancedBackupSetting = AdvancedBackupSetting(this)
    }
}
