// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.CalculatedLifecycle
import aws.sdk.kotlin.services.backup.model.Lifecycle
import aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateRecoveryPointLifecycleOperationDeserializer: HttpDeserializer.NonStreaming<UpdateRecoveryPointLifecycleResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateRecoveryPointLifecycleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateRecoveryPointLifecycleError(context, call, payload)
        }
        val builder = UpdateRecoveryPointLifecycleResponse.Builder()

        if (payload != null) {
            deserializeUpdateRecoveryPointLifecycleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateRecoveryPointLifecycleError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRecoveryPointLifecycleOperationBody(builder: UpdateRecoveryPointLifecycleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultArn"))
    val CALCULATEDLIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CalculatedLifecycle"))
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Lifecycle"))
    val RECOVERYPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RecoveryPointArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPVAULTARN_DESCRIPTOR)
        field(CALCULATEDLIFECYCLE_DESCRIPTOR)
        field(LIFECYCLE_DESCRIPTOR)
        field(RECOVERYPOINTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPVAULTARN_DESCRIPTOR.index -> builder.backupVaultArn = deserializeString()
                CALCULATEDLIFECYCLE_DESCRIPTOR.index -> builder.calculatedLifecycle = deserializeCalculatedLifecycleDocument(deserializer)
                LIFECYCLE_DESCRIPTOR.index -> builder.lifecycle = deserializeLifecycleDocument(deserializer)
                RECOVERYPOINTARN_DESCRIPTOR.index -> builder.recoveryPointArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
