// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.BackupVaultEvent
import aws.sdk.kotlin.services.backup.model.GetBackupVaultNotificationsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetBackupVaultNotificationsOperationDeserializer: HttpDeserializer.NonStreaming<GetBackupVaultNotificationsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetBackupVaultNotificationsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBackupVaultNotificationsError(context, call, payload)
        }
        val builder = GetBackupVaultNotificationsResponse.Builder()

        if (payload != null) {
            deserializeGetBackupVaultNotificationsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetBackupVaultNotificationsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBackupVaultNotificationsOperationBody(builder: GetBackupVaultNotificationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultArn"))
    val BACKUPVAULTEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("BackupVaultEvents"))
    val BACKUPVAULTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultName"))
    val SNSTOPICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SNSTopicArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPVAULTARN_DESCRIPTOR)
        field(BACKUPVAULTEVENTS_DESCRIPTOR)
        field(BACKUPVAULTNAME_DESCRIPTOR)
        field(SNSTOPICARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPVAULTARN_DESCRIPTOR.index -> builder.backupVaultArn = deserializeString()
                BACKUPVAULTEVENTS_DESCRIPTOR.index -> builder.backupVaultEvents =
                    deserializer.deserializeList(BACKUPVAULTEVENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<BackupVaultEvent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { BackupVaultEvent.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BACKUPVAULTNAME_DESCRIPTOR.index -> builder.backupVaultName = deserializeString()
                SNSTOPICARN_DESCRIPTOR.index -> builder.snsTopicArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
