// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.DescribeBackupVaultResponse
import aws.sdk.kotlin.services.backup.model.LatestMpaApprovalTeamUpdate
import aws.sdk.kotlin.services.backup.model.VaultState
import aws.sdk.kotlin.services.backup.model.VaultType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeBackupVaultOperationDeserializer: HttpDeserializer.NonStreaming<DescribeBackupVaultResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeBackupVaultResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeBackupVaultError(context, call, payload)
        }
        val builder = DescribeBackupVaultResponse.Builder()

        if (payload != null) {
            deserializeDescribeBackupVaultOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeBackupVaultError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBackupVaultOperationBody(builder: DescribeBackupVaultResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultArn"))
    val BACKUPVAULTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultName"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val CREATORREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatorRequestId"))
    val ENCRYPTIONKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EncryptionKeyArn"))
    val LATESTMPAAPPROVALTEAMUPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LatestMpaApprovalTeamUpdate"))
    val LOCKDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LockDate"))
    val LOCKED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Locked"))
    val MAXRETENTIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("MaxRetentionDays"))
    val MINRETENTIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("MinRetentionDays"))
    val MPAAPPROVALTEAMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MpaApprovalTeamArn"))
    val MPASESSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MpaSessionArn"))
    val NUMBEROFRECOVERYPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfRecoveryPoints"))
    val SOURCEBACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceBackupVaultArn"))
    val VAULTSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("VaultState"))
    val VAULTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("VaultType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPVAULTARN_DESCRIPTOR)
        field(BACKUPVAULTNAME_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(CREATORREQUESTID_DESCRIPTOR)
        field(ENCRYPTIONKEYARN_DESCRIPTOR)
        field(LATESTMPAAPPROVALTEAMUPDATE_DESCRIPTOR)
        field(LOCKDATE_DESCRIPTOR)
        field(LOCKED_DESCRIPTOR)
        field(MAXRETENTIONDAYS_DESCRIPTOR)
        field(MINRETENTIONDAYS_DESCRIPTOR)
        field(MPAAPPROVALTEAMARN_DESCRIPTOR)
        field(MPASESSIONARN_DESCRIPTOR)
        field(NUMBEROFRECOVERYPOINTS_DESCRIPTOR)
        field(SOURCEBACKUPVAULTARN_DESCRIPTOR)
        field(VAULTSTATE_DESCRIPTOR)
        field(VAULTTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPVAULTARN_DESCRIPTOR.index -> builder.backupVaultArn = deserializeString()
                BACKUPVAULTNAME_DESCRIPTOR.index -> builder.backupVaultName = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                CREATORREQUESTID_DESCRIPTOR.index -> builder.creatorRequestId = deserializeString()
                ENCRYPTIONKEYARN_DESCRIPTOR.index -> builder.encryptionKeyArn = deserializeString()
                LATESTMPAAPPROVALTEAMUPDATE_DESCRIPTOR.index -> builder.latestMpaApprovalTeamUpdate = deserializeLatestMpaApprovalTeamUpdateDocument(deserializer)
                LOCKDATE_DESCRIPTOR.index -> builder.lockDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LOCKED_DESCRIPTOR.index -> builder.locked = deserializeBoolean()
                MAXRETENTIONDAYS_DESCRIPTOR.index -> builder.maxRetentionDays = deserializeLong()
                MINRETENTIONDAYS_DESCRIPTOR.index -> builder.minRetentionDays = deserializeLong()
                MPAAPPROVALTEAMARN_DESCRIPTOR.index -> builder.mpaApprovalTeamArn = deserializeString()
                MPASESSIONARN_DESCRIPTOR.index -> builder.mpaSessionArn = deserializeString()
                NUMBEROFRECOVERYPOINTS_DESCRIPTOR.index -> builder.numberOfRecoveryPoints = deserializeLong()
                SOURCEBACKUPVAULTARN_DESCRIPTOR.index -> builder.sourceBackupVaultArn = deserializeString()
                VAULTSTATE_DESCRIPTOR.index -> builder.vaultState = deserializeString().let { VaultState.fromValue(it) }
                VAULTTYPE_DESCRIPTOR.index -> builder.vaultType = deserializeString().let { VaultType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
