// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.BackupJobState
import aws.sdk.kotlin.services.backup.model.DescribeBackupJobResponse
import aws.sdk.kotlin.services.backup.model.RecoveryPointCreator
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class DescribeBackupJobOperationDeserializer: HttpDeserializer.NonStreaming<DescribeBackupJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeBackupJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeBackupJobError(context, call, payload)
        }
        val builder = DescribeBackupJobResponse.Builder()

        if (payload != null) {
            deserializeDescribeBackupJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeBackupJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DependencyFailureException" -> DependencyFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBackupJobOperationBody(builder: DescribeBackupJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccountId"))
    val BACKUPJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupJobId"))
    val BACKUPOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("BackupOptions"))
    val BACKUPSIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BackupSizeInBytes"))
    val BACKUPTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupType"))
    val BACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultArn"))
    val BACKUPVAULTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultName"))
    val BYTESTRANSFERRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BytesTransferred"))
    val CHILDJOBSINSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ChildJobsInState"))
    val COMPLETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletionDate"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val EXPECTEDCOMPLETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ExpectedCompletionDate"))
    val IAMROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IamRoleArn"))
    val INITIATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("InitiationDate"))
    val ISPARENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsParent"))
    val MESSAGECATEGORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MessageCategory"))
    val NUMBEROFCHILDJOBS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfChildJobs"))
    val PARENTJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ParentJobId"))
    val PERCENTDONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PercentDone"))
    val RECOVERYPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RecoveryPointArn"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceArn"))
    val RESOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceName"))
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceType"))
    val STARTBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartBy"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTID_DESCRIPTOR)
        field(BACKUPJOBID_DESCRIPTOR)
        field(BACKUPOPTIONS_DESCRIPTOR)
        field(BACKUPSIZEINBYTES_DESCRIPTOR)
        field(BACKUPTYPE_DESCRIPTOR)
        field(BACKUPVAULTARN_DESCRIPTOR)
        field(BACKUPVAULTNAME_DESCRIPTOR)
        field(BYTESTRANSFERRED_DESCRIPTOR)
        field(CHILDJOBSINSTATE_DESCRIPTOR)
        field(COMPLETIONDATE_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(EXPECTEDCOMPLETIONDATE_DESCRIPTOR)
        field(IAMROLEARN_DESCRIPTOR)
        field(INITIATIONDATE_DESCRIPTOR)
        field(ISPARENT_DESCRIPTOR)
        field(MESSAGECATEGORY_DESCRIPTOR)
        field(NUMBEROFCHILDJOBS_DESCRIPTOR)
        field(PARENTJOBID_DESCRIPTOR)
        field(PERCENTDONE_DESCRIPTOR)
        field(RECOVERYPOINTARN_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(RESOURCENAME_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
        field(STARTBY_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTID_DESCRIPTOR.index -> builder.accountId = deserializeString()
                BACKUPJOBID_DESCRIPTOR.index -> builder.backupJobId = deserializeString()
                BACKUPOPTIONS_DESCRIPTOR.index -> builder.backupOptions =
                    deserializer.deserializeMap(BACKUPOPTIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                BACKUPSIZEINBYTES_DESCRIPTOR.index -> builder.backupSizeInBytes = deserializeLong()
                BACKUPTYPE_DESCRIPTOR.index -> builder.backupType = deserializeString()
                BACKUPVAULTARN_DESCRIPTOR.index -> builder.backupVaultArn = deserializeString()
                BACKUPVAULTNAME_DESCRIPTOR.index -> builder.backupVaultName = deserializeString()
                BYTESTRANSFERRED_DESCRIPTOR.index -> builder.bytesTransferred = deserializeLong()
                CHILDJOBSINSTATE_DESCRIPTOR.index -> builder.childJobsInState =
                    deserializer.deserializeMap(CHILDJOBSINSTATE_DESCRIPTOR) {
                        val map0 = mutableMapOf<BackupJobState, Long>()
                        while (hasNextEntry()) {
                            val k0 = BackupJobState.fromValue(key())
                            val v0 = if (nextHasValue()) { deserializeLong() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                COMPLETIONDATE_DESCRIPTOR.index -> builder.completionDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeRecoveryPointCreatorDocument(deserializer)
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                EXPECTEDCOMPLETIONDATE_DESCRIPTOR.index -> builder.expectedCompletionDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                IAMROLEARN_DESCRIPTOR.index -> builder.iamRoleArn = deserializeString()
                INITIATIONDATE_DESCRIPTOR.index -> builder.initiationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ISPARENT_DESCRIPTOR.index -> builder.isParent = deserializeBoolean()
                MESSAGECATEGORY_DESCRIPTOR.index -> builder.messageCategory = deserializeString()
                NUMBEROFCHILDJOBS_DESCRIPTOR.index -> builder.numberOfChildJobs = deserializeLong()
                PARENTJOBID_DESCRIPTOR.index -> builder.parentJobId = deserializeString()
                PERCENTDONE_DESCRIPTOR.index -> builder.percentDone = deserializeString()
                RECOVERYPOINTARN_DESCRIPTOR.index -> builder.recoveryPointArn = deserializeString()
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                RESOURCENAME_DESCRIPTOR.index -> builder.resourceName = deserializeString()
                RESOURCETYPE_DESCRIPTOR.index -> builder.resourceType = deserializeString()
                STARTBY_DESCRIPTOR.index -> builder.startBy = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { BackupJobState.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
