// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateRegionSettingsRequest private constructor(builder: Builder) {
    /**
     * Enables or disables full Backup management of backups for a resource type. To enable full Backup management for DynamoDB along with [ Backup's advanced DynamoDB backup features](https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html), follow the procedure to [ enable advanced DynamoDB backup programmatically](https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html#advanced-ddb-backup-enable-cli).
     */
    public val resourceTypeManagementPreference: Map<String, Boolean>? = builder.resourceTypeManagementPreference
    /**
     * Updates the list of services along with the opt-in preferences for the Region.
     *
     * If resource assignments are only based on tags, then service opt-in settings are applied. If a resource type is explicitly assigned to a backup plan, such as Amazon S3, Amazon EC2, or Amazon RDS, it will be included in the backup even if the opt-in is not enabled for that particular service. If both a resource type and tags are specified in a resource assignment, the resource type specified in the backup plan takes priority over the tag condition. Service opt-in settings are disregarded in this situation.
     */
    public val resourceTypeOptInPreference: Map<String, Boolean>? = builder.resourceTypeOptInPreference

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.UpdateRegionSettingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRegionSettingsRequest(")
        append("resourceTypeManagementPreference=$resourceTypeManagementPreference,")
        append("resourceTypeOptInPreference=$resourceTypeOptInPreference")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceTypeManagementPreference?.hashCode() ?: 0
        result = 31 * result + (resourceTypeOptInPreference?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRegionSettingsRequest

        if (resourceTypeManagementPreference != other.resourceTypeManagementPreference) return false
        if (resourceTypeOptInPreference != other.resourceTypeOptInPreference) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.UpdateRegionSettingsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Enables or disables full Backup management of backups for a resource type. To enable full Backup management for DynamoDB along with [ Backup's advanced DynamoDB backup features](https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html), follow the procedure to [ enable advanced DynamoDB backup programmatically](https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html#advanced-ddb-backup-enable-cli).
         */
        public var resourceTypeManagementPreference: Map<String, Boolean>? = null
        /**
         * Updates the list of services along with the opt-in preferences for the Region.
         *
         * If resource assignments are only based on tags, then service opt-in settings are applied. If a resource type is explicitly assigned to a backup plan, such as Amazon S3, Amazon EC2, or Amazon RDS, it will be included in the backup even if the opt-in is not enabled for that particular service. If both a resource type and tags are specified in a resource assignment, the resource type specified in the backup plan takes priority over the tag condition. Service opt-in settings are disregarded in this situation.
         */
        public var resourceTypeOptInPreference: Map<String, Boolean>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.UpdateRegionSettingsRequest) : this() {
            this.resourceTypeManagementPreference = x.resourceTypeManagementPreference
            this.resourceTypeOptInPreference = x.resourceTypeOptInPreference
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.UpdateRegionSettingsRequest = UpdateRegionSettingsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
