// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartRestoreJobRequest private constructor(builder: Builder) {
    /**
     * This is an optional parameter. If this equals `True`, tags included in the backup will be copied to the restored resource.
     *
     * This can only be applied to backups created through Backup.
     */
    public val copySourceTagsToRestoredResource: kotlin.Boolean? = builder.copySourceTagsToRestoredResource
    /**
     * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to `StartRestoreJob`. Retrying a successful request with the same idempotency token results in a success message with no action taken.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * A set of metadata key-value pairs.
     *
     * You can get configuration metadata about a resource at the time it was backed up by calling `GetRecoveryPointRestoreMetadata`. However, values in addition to those provided by `GetRecoveryPointRestoreMetadata` might be required to restore a resource. For example, you might need to provide a new resource name if the original already exists.
     *
     * For more information about the metadata for each resource, see the following:
     * + [Metadata for Amazon Aurora](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-aur.html#aur-restore-cli)
     * + [Metadata for Amazon DocumentDB](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-docdb.html#docdb-restore-cli)
     * + [Metadata for CloudFormation](https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-application-stacks.html#restoring-cfn-cli)
     * + [Metadata for Amazon DynamoDB](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-dynamodb.html#ddb-restore-cli)
     * + [ Metadata for Amazon EBS](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-ebs.html#ebs-restore-cli)
     * + [Metadata for Amazon EC2](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-ec2.html#restoring-ec2-cli)
     * + [Metadata for Amazon EFS](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-efs.html#efs-restore-cli)
     * + [Metadata for Amazon FSx](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-fsx.html#fsx-restore-cli)
     * + [Metadata for Amazon Neptune](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-nep.html#nep-restore-cli)
     * + [Metadata for Amazon RDS](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-rds.html#rds-restore-cli)
     * + [Metadata for Amazon Redshift](https://docs.aws.amazon.com/aws-backup/latest/devguide/redshift-restores.html#redshift-restore-api)
     * + [Metadata for Storage Gateway](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-storage-gateway.html#restoring-sgw-cli)
     * + [Metadata for Amazon S3](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-s3.html#s3-restore-cli)
     * + [Metadata for Amazon Timestream](https://docs.aws.amazon.com/aws-backup/latest/devguide/timestream-restore.html#timestream-restore-api)
     * + [Metadata for virtual machines](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-vm.html#vm-restore-cli)
     */
    public val metadata: Map<String, String>? = builder.metadata
    /**
     * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * Starts a job to restore a recovery point for one of the following resources:
     * + `Aurora` - Amazon Aurora
     * + `DocumentDB` - Amazon DocumentDB
     * + `CloudFormation` - CloudFormation
     * + `DynamoDB` - Amazon DynamoDB
     * + `EBS` - Amazon Elastic Block Store
     * + `EC2` - Amazon Elastic Compute Cloud
     * + `EFS` - Amazon Elastic File System
     * + `FSx` - Amazon FSx
     * + `Neptune` - Amazon Neptune
     * + `RDS` - Amazon Relational Database Service
     * + `Redshift` - Amazon Redshift
     * + `Storage Gateway` - Storage Gateway
     * + `S3` - Amazon Simple Storage Service
     * + `Timestream` - Amazon Timestream
     * + `VirtualMachine` - Virtual machines
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.StartRestoreJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartRestoreJobRequest(")
        append("copySourceTagsToRestoredResource=$copySourceTagsToRestoredResource,")
        append("iamRoleArn=$iamRoleArn,")
        append("idempotencyToken=$idempotencyToken,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copySourceTagsToRestoredResource?.hashCode() ?: 0
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartRestoreJobRequest

        if (copySourceTagsToRestoredResource != other.copySourceTagsToRestoredResource) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (metadata != other.metadata) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.StartRestoreJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This is an optional parameter. If this equals `True`, tags included in the backup will be copied to the restored resource.
         *
         * This can only be applied to backups created through Backup.
         */
        public var copySourceTagsToRestoredResource: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to `StartRestoreJob`. Retrying a successful request with the same idempotency token results in a success message with no action taken.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * A set of metadata key-value pairs.
         *
         * You can get configuration metadata about a resource at the time it was backed up by calling `GetRecoveryPointRestoreMetadata`. However, values in addition to those provided by `GetRecoveryPointRestoreMetadata` might be required to restore a resource. For example, you might need to provide a new resource name if the original already exists.
         *
         * For more information about the metadata for each resource, see the following:
         * + [Metadata for Amazon Aurora](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-aur.html#aur-restore-cli)
         * + [Metadata for Amazon DocumentDB](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-docdb.html#docdb-restore-cli)
         * + [Metadata for CloudFormation](https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-application-stacks.html#restoring-cfn-cli)
         * + [Metadata for Amazon DynamoDB](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-dynamodb.html#ddb-restore-cli)
         * + [ Metadata for Amazon EBS](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-ebs.html#ebs-restore-cli)
         * + [Metadata for Amazon EC2](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-ec2.html#restoring-ec2-cli)
         * + [Metadata for Amazon EFS](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-efs.html#efs-restore-cli)
         * + [Metadata for Amazon FSx](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-fsx.html#fsx-restore-cli)
         * + [Metadata for Amazon Neptune](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-nep.html#nep-restore-cli)
         * + [Metadata for Amazon RDS](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-rds.html#rds-restore-cli)
         * + [Metadata for Amazon Redshift](https://docs.aws.amazon.com/aws-backup/latest/devguide/redshift-restores.html#redshift-restore-api)
         * + [Metadata for Storage Gateway](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-storage-gateway.html#restoring-sgw-cli)
         * + [Metadata for Amazon S3](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-s3.html#s3-restore-cli)
         * + [Metadata for Amazon Timestream](https://docs.aws.amazon.com/aws-backup/latest/devguide/timestream-restore.html#timestream-restore-api)
         * + [Metadata for virtual machines](https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-vm.html#vm-restore-cli)
         */
        public var metadata: Map<String, String>? = null
        /**
         * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * Starts a job to restore a recovery point for one of the following resources:
         * + `Aurora` - Amazon Aurora
         * + `DocumentDB` - Amazon DocumentDB
         * + `CloudFormation` - CloudFormation
         * + `DynamoDB` - Amazon DynamoDB
         * + `EBS` - Amazon Elastic Block Store
         * + `EC2` - Amazon Elastic Compute Cloud
         * + `EFS` - Amazon Elastic File System
         * + `FSx` - Amazon FSx
         * + `Neptune` - Amazon Neptune
         * + `RDS` - Amazon Relational Database Service
         * + `Redshift` - Amazon Redshift
         * + `Storage Gateway` - Storage Gateway
         * + `S3` - Amazon Simple Storage Service
         * + `Timestream` - Amazon Timestream
         * + `VirtualMachine` - Virtual machines
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.StartRestoreJobRequest) : this() {
            this.copySourceTagsToRestoredResource = x.copySourceTagsToRestoredResource
            this.iamRoleArn = x.iamRoleArn
            this.idempotencyToken = x.idempotencyToken
            this.metadata = x.metadata
            this.recoveryPointArn = x.recoveryPointArn
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.StartRestoreJobRequest = StartRestoreJobRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
