// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This contains metadata about a specific restore testing selection.
 *
 * ProtectedResourceType is required, such as Amazon EBS or Amazon EC2.
 *
 * This consists of `RestoreTestingSelectionName`, `ProtectedResourceType`, and one of the following:
 * + `ProtectedResourceArns`
 * + `ProtectedResourceConditions`
 *
 * Each protected resource type can have one single value.
 *
 * A restore testing selection can include a wildcard value ("*") for `ProtectedResourceArns` along with `ProtectedResourceConditions`. Alternatively, you can include up to 30 specific protected resource ARNs in `ProtectedResourceArns`.
 *
 * `ProtectedResourceConditions` examples include as `StringEquals` and `StringNotEquals`.
 */
public class RestoreTestingSelectionForCreate private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String = requireNotNull(builder.iamRoleArn) { "A non-null value must be provided for iamRoleArn" }
    /**
     * Each protected resource can be filtered by its specific ARNs, such as `ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]` or by a wildcard: `ProtectedResourceArns: ["*"]`, but not both.
     */
    public val protectedResourceArns: List<String>? = builder.protectedResourceArns
    /**
     * If you have included the wildcard in ProtectedResourceArns, you can include resource conditions, such as `ProtectedResourceConditions: { StringEquals: [{ key: "XXXX", value: "YYYY" }]`.
     */
    public val protectedResourceConditions: aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions? = builder.protectedResourceConditions
    /**
     * The type of Amazon Web Services resource included in a restore testing selection; for example, an Amazon EBS volume or an Amazon RDS database.
     *
     * Supported resource types accepted include:
     * + `Aurora` for Amazon Aurora
     * + `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
     * + `DynamoDB` for Amazon DynamoDB
     * + `EBS` for Amazon Elastic Block Store
     * + `EC2` for Amazon Elastic Compute Cloud
     * + `EFS` for Amazon Elastic File System
     * + `FSx` for Amazon FSx
     * + `Neptune` for Amazon Neptune
     * + `RDS` for Amazon Relational Database Service
     * + `S3` for Amazon S3
     */
    public val protectedResourceType: kotlin.String = requireNotNull(builder.protectedResourceType) { "A non-null value must be provided for protectedResourceType" }
    /**
     * You can override certain restore metadata keys by including the parameter `RestoreMetadataOverrides` in the body of `RestoreTestingSelection`. Key values are not case sensitive.
     *
     * See the complete list of [restore testing inferred metadata](https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html).
     */
    public val restoreMetadataOverrides: Map<String, String>? = builder.restoreMetadataOverrides
    /**
     * The unique name of the restore testing selection that belongs to the related restore testing plan.
     */
    public val restoreTestingSelectionName: kotlin.String = requireNotNull(builder.restoreTestingSelectionName) { "A non-null value must be provided for restoreTestingSelectionName" }
    /**
     * This is amount of hours (0 to 168) available to run a validation script on the data. The data will be deleted upon the completion of the validation script or the end of the specified retention period, whichever comes first.
     */
    public val validationWindowHours: kotlin.Int = builder.validationWindowHours

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForCreate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTestingSelectionForCreate(")
        append("iamRoleArn=$iamRoleArn,")
        append("protectedResourceArns=$protectedResourceArns,")
        append("protectedResourceConditions=$protectedResourceConditions,")
        append("protectedResourceType=$protectedResourceType,")
        append("restoreMetadataOverrides=*** Sensitive Data Redacted ***,")
        append("restoreTestingSelectionName=$restoreTestingSelectionName,")
        append("validationWindowHours=$validationWindowHours")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = iamRoleArn.hashCode()
        result = 31 * result + (protectedResourceArns?.hashCode() ?: 0)
        result = 31 * result + (protectedResourceConditions?.hashCode() ?: 0)
        result = 31 * result + (protectedResourceType.hashCode())
        result = 31 * result + (restoreMetadataOverrides?.hashCode() ?: 0)
        result = 31 * result + (restoreTestingSelectionName.hashCode())
        result = 31 * result + (validationWindowHours)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreTestingSelectionForCreate

        if (iamRoleArn != other.iamRoleArn) return false
        if (protectedResourceArns != other.protectedResourceArns) return false
        if (protectedResourceConditions != other.protectedResourceConditions) return false
        if (protectedResourceType != other.protectedResourceType) return false
        if (restoreMetadataOverrides != other.restoreMetadataOverrides) return false
        if (restoreTestingSelectionName != other.restoreTestingSelectionName) return false
        if (validationWindowHours != other.validationWindowHours) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForCreate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * Each protected resource can be filtered by its specific ARNs, such as `ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]` or by a wildcard: `ProtectedResourceArns: ["*"]`, but not both.
         */
        public var protectedResourceArns: List<String>? = null
        /**
         * If you have included the wildcard in ProtectedResourceArns, you can include resource conditions, such as `ProtectedResourceConditions: { StringEquals: [{ key: "XXXX", value: "YYYY" }]`.
         */
        public var protectedResourceConditions: aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions? = null
        /**
         * The type of Amazon Web Services resource included in a restore testing selection; for example, an Amazon EBS volume or an Amazon RDS database.
         *
         * Supported resource types accepted include:
         * + `Aurora` for Amazon Aurora
         * + `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
         * + `DynamoDB` for Amazon DynamoDB
         * + `EBS` for Amazon Elastic Block Store
         * + `EC2` for Amazon Elastic Compute Cloud
         * + `EFS` for Amazon Elastic File System
         * + `FSx` for Amazon FSx
         * + `Neptune` for Amazon Neptune
         * + `RDS` for Amazon Relational Database Service
         * + `S3` for Amazon S3
         */
        public var protectedResourceType: kotlin.String? = null
        /**
         * You can override certain restore metadata keys by including the parameter `RestoreMetadataOverrides` in the body of `RestoreTestingSelection`. Key values are not case sensitive.
         *
         * See the complete list of [restore testing inferred metadata](https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html).
         */
        public var restoreMetadataOverrides: Map<String, String>? = null
        /**
         * The unique name of the restore testing selection that belongs to the related restore testing plan.
         */
        public var restoreTestingSelectionName: kotlin.String? = null
        /**
         * This is amount of hours (0 to 168) available to run a validation script on the data. The data will be deleted upon the completion of the validation script or the end of the specified retention period, whichever comes first.
         */
        public var validationWindowHours: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForCreate) : this() {
            this.iamRoleArn = x.iamRoleArn
            this.protectedResourceArns = x.protectedResourceArns
            this.protectedResourceConditions = x.protectedResourceConditions
            this.protectedResourceType = x.protectedResourceType
            this.restoreMetadataOverrides = x.restoreMetadataOverrides
            this.restoreTestingSelectionName = x.restoreTestingSelectionName
            this.validationWindowHours = x.validationWindowHours
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForCreate = RestoreTestingSelectionForCreate(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions] inside the given [block]
         */
        public fun protectedResourceConditions(block: aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions.Builder.() -> kotlin.Unit) {
            this.protectedResourceConditions = aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (iamRoleArn == null) iamRoleArn = ""
            if (protectedResourceType == null) protectedResourceType = ""
            if (restoreTestingSelectionName == null) restoreTestingSelectionName = ""
            return this
        }
    }
}
