// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * `RecoveryPointSelection` has five parameters (three required and two optional). The values you specify determine which recovery point is included in the restore test. You must indicate with `Algorithm` if you want the latest recovery point within your `SelectionWindowDays` or if you want a random recovery point, and you must indicate through `IncludeVaults` from which vaults the recovery points can be chosen.
 *
 * `Algorithm` (*required*) Valid values: "`LATEST_WITHIN_WINDOW`" or "`RANDOM_WITHIN_WINDOW`".
 *
 * `Recovery point types` (*required*) Valid values: "`SNAPSHOT`" and/or "`CONTINUOUS`". Include `SNAPSHOT` to restore only snapshot recovery points; include `CONTINUOUS` to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for `Algorithm`.
 *
 * `IncludeVaults` (*required*). You must include one or more backup vaults. Use the wildcard &#91;"*"&#93; or specific ARNs.
 *
 * `SelectionWindowDays` (*optional*) Value must be an integer (in days) from 1 to 365. If not included, the value defaults to `30`.
 *
 * `ExcludeVaults` (*optional*). You can choose to input one or more specific backup vault ARNs to exclude those vaults' contents from restore eligibility. Or, you can include a list of selectors. If this parameter and its value are not included, it defaults to empty list.
 */
public class RestoreTestingRecoveryPointSelection private constructor(builder: Builder) {
    /**
     * Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW"
     */
    public val algorithm: aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelectionAlgorithm? = builder.algorithm
    /**
     * Accepted values include specific ARNs or list of selectors. Defaults to empty list if not listed.
     */
    public val excludeVaults: List<String>? = builder.excludeVaults
    /**
     * Accepted values include wildcard &#91;"*"&#93; or by specific ARNs or ARN wilcard replacement &#91;"arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...&#93; &#91;"arn:aws:backup:*:*:backup-vault:asdf-*", ...&#93;
     */
    public val includeVaults: List<String>? = builder.includeVaults
    /**
     * These are the types of recovery points.
     *
     * Include `SNAPSHOT` to restore only snapshot recovery points; include `CONTINUOUS` to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for `Algorithm`.
     */
    public val recoveryPointTypes: List<RestoreTestingRecoveryPointType>? = builder.recoveryPointTypes
    /**
     * Accepted values are integers from 1 to 365.
     */
    public val selectionWindowDays: kotlin.Int = builder.selectionWindowDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTestingRecoveryPointSelection(")
        append("algorithm=$algorithm,")
        append("excludeVaults=$excludeVaults,")
        append("includeVaults=$includeVaults,")
        append("recoveryPointTypes=$recoveryPointTypes,")
        append("selectionWindowDays=$selectionWindowDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithm?.hashCode() ?: 0
        result = 31 * result + (excludeVaults?.hashCode() ?: 0)
        result = 31 * result + (includeVaults?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointTypes?.hashCode() ?: 0)
        result = 31 * result + (selectionWindowDays)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreTestingRecoveryPointSelection

        if (algorithm != other.algorithm) return false
        if (excludeVaults != other.excludeVaults) return false
        if (includeVaults != other.includeVaults) return false
        if (recoveryPointTypes != other.recoveryPointTypes) return false
        if (selectionWindowDays != other.selectionWindowDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW"
         */
        public var algorithm: aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelectionAlgorithm? = null
        /**
         * Accepted values include specific ARNs or list of selectors. Defaults to empty list if not listed.
         */
        public var excludeVaults: List<String>? = null
        /**
         * Accepted values include wildcard &#91;"*"&#93; or by specific ARNs or ARN wilcard replacement &#91;"arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...&#93; &#91;"arn:aws:backup:*:*:backup-vault:asdf-*", ...&#93;
         */
        public var includeVaults: List<String>? = null
        /**
         * These are the types of recovery points.
         *
         * Include `SNAPSHOT` to restore only snapshot recovery points; include `CONTINUOUS` to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for `Algorithm`.
         */
        public var recoveryPointTypes: List<RestoreTestingRecoveryPointType>? = null
        /**
         * Accepted values are integers from 1 to 365.
         */
        public var selectionWindowDays: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection) : this() {
            this.algorithm = x.algorithm
            this.excludeVaults = x.excludeVaults
            this.includeVaults = x.includeVaults
            this.recoveryPointTypes = x.recoveryPointTypes
            this.selectionWindowDays = x.selectionWindowDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection = RestoreTestingRecoveryPointSelection(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
