// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This contains metadata about a restore testing plan.
 */
public class RestoreTestingPlanForUpdate private constructor(builder: Builder) {
    /**
     * Required: `Algorithm`; `RecoveryPointTypes`; `IncludeVaults` (*one or more*).
     *
     * Optional: *SelectionWindowDays* (*'30' if not specified*); `ExcludeVaults` (defaults to empty list if not listed).
     */
    public val recoveryPointSelection: aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection? = builder.recoveryPointSelection
    /**
     * A CRON expression in specified timezone when a restore testing plan is executed. When no CRON expression is provided, Backup will use the default expression `cron(0 5 ? * * *)`.
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
     */
    public val scheduleExpressionTimezone: kotlin.String? = builder.scheduleExpressionTimezone
    /**
     * Defaults to 24 hours.
     *
     * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
     */
    public val startWindowHours: kotlin.Int = builder.startWindowHours

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTestingPlanForUpdate(")
        append("recoveryPointSelection=$recoveryPointSelection,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleExpressionTimezone=$scheduleExpressionTimezone,")
        append("startWindowHours=$startWindowHours")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = recoveryPointSelection?.hashCode() ?: 0
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpressionTimezone?.hashCode() ?: 0)
        result = 31 * result + (startWindowHours)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreTestingPlanForUpdate

        if (recoveryPointSelection != other.recoveryPointSelection) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleExpressionTimezone != other.scheduleExpressionTimezone) return false
        if (startWindowHours != other.startWindowHours) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Required: `Algorithm`; `RecoveryPointTypes`; `IncludeVaults` (*one or more*).
         *
         * Optional: *SelectionWindowDays* (*'30' if not specified*); `ExcludeVaults` (defaults to empty list if not listed).
         */
        public var recoveryPointSelection: aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection? = null
        /**
         * A CRON expression in specified timezone when a restore testing plan is executed. When no CRON expression is provided, Backup will use the default expression `cron(0 5 ? * * *)`.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         */
        public var scheduleExpressionTimezone: kotlin.String? = null
        /**
         * Defaults to 24 hours.
         *
         * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
         */
        public var startWindowHours: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForUpdate) : this() {
            this.recoveryPointSelection = x.recoveryPointSelection
            this.scheduleExpression = x.scheduleExpression
            this.scheduleExpressionTimezone = x.scheduleExpressionTimezone
            this.startWindowHours = x.startWindowHours
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForUpdate = RestoreTestingPlanForUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection] inside the given [block]
         */
        public fun recoveryPointSelection(block: aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection.Builder.() -> kotlin.Unit) {
            this.recoveryPointSelection = aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
