// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This contains metadata about a restore testing plan.
 */
public class RestoreTestingPlanForCreate private constructor(builder: Builder) {
    /**
     * `RecoveryPointSelection` has five parameters (three required and two optional). The values you specify determine which recovery point is included in the restore test. You must indicate with `Algorithm` if you want the latest recovery point within your `SelectionWindowDays` or if you want a random recovery point, and you must indicate through `IncludeVaults` from which vaults the recovery points can be chosen.
     *
     * `Algorithm` (*required*) Valid values: "`LATEST_WITHIN_WINDOW`" or "`RANDOM_WITHIN_WINDOW`".
     *
     * `Recovery point types` (*required*) Valid values: "`SNAPSHOT`" and/or "`CONTINUOUS`". Include `SNAPSHOT` to restore only snapshot recovery points; include `CONTINUOUS` to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for `Algorithm`.
     *
     * `IncludeVaults` (*required*). You must include one or more backup vaults. Use the wildcard &#91;"*"&#93; or specific ARNs.
     *
     * `SelectionWindowDays` (*optional*) Value must be an integer (in days) from 1 to 365. If not included, the value defaults to `30`.
     *
     * `ExcludeVaults` (*optional*). You can choose to input one or more specific backup vault ARNs to exclude those vaults' contents from restore eligibility. Or, you can include a list of selectors. If this parameter and its value are not included, it defaults to empty list.
     */
    public val recoveryPointSelection: aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection? = builder.recoveryPointSelection
    /**
     * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
     */
    public val restoreTestingPlanName: kotlin.String = requireNotNull(builder.restoreTestingPlanName) { "A non-null value must be provided for restoreTestingPlanName" }
    /**
     * A CRON expression in specified timezone when a restore testing plan is executed. When no CRON expression is provided, Backup will use the default expression `cron(0 5 ? * * *)`.
     */
    public val scheduleExpression: kotlin.String = requireNotNull(builder.scheduleExpression) { "A non-null value must be provided for scheduleExpression" }
    /**
     * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
     */
    public val scheduleExpressionTimezone: kotlin.String? = builder.scheduleExpressionTimezone
    /**
     * Defaults to 24 hours.
     *
     * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
     */
    public val startWindowHours: kotlin.Int = builder.startWindowHours

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForCreate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTestingPlanForCreate(")
        append("recoveryPointSelection=$recoveryPointSelection,")
        append("restoreTestingPlanName=$restoreTestingPlanName,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleExpressionTimezone=$scheduleExpressionTimezone,")
        append("startWindowHours=$startWindowHours")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = recoveryPointSelection?.hashCode() ?: 0
        result = 31 * result + (restoreTestingPlanName.hashCode())
        result = 31 * result + (scheduleExpression.hashCode())
        result = 31 * result + (scheduleExpressionTimezone?.hashCode() ?: 0)
        result = 31 * result + (startWindowHours)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreTestingPlanForCreate

        if (recoveryPointSelection != other.recoveryPointSelection) return false
        if (restoreTestingPlanName != other.restoreTestingPlanName) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleExpressionTimezone != other.scheduleExpressionTimezone) return false
        if (startWindowHours != other.startWindowHours) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForCreate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * `RecoveryPointSelection` has five parameters (three required and two optional). The values you specify determine which recovery point is included in the restore test. You must indicate with `Algorithm` if you want the latest recovery point within your `SelectionWindowDays` or if you want a random recovery point, and you must indicate through `IncludeVaults` from which vaults the recovery points can be chosen.
         *
         * `Algorithm` (*required*) Valid values: "`LATEST_WITHIN_WINDOW`" or "`RANDOM_WITHIN_WINDOW`".
         *
         * `Recovery point types` (*required*) Valid values: "`SNAPSHOT`" and/or "`CONTINUOUS`". Include `SNAPSHOT` to restore only snapshot recovery points; include `CONTINUOUS` to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for `Algorithm`.
         *
         * `IncludeVaults` (*required*). You must include one or more backup vaults. Use the wildcard &#91;"*"&#93; or specific ARNs.
         *
         * `SelectionWindowDays` (*optional*) Value must be an integer (in days) from 1 to 365. If not included, the value defaults to `30`.
         *
         * `ExcludeVaults` (*optional*). You can choose to input one or more specific backup vault ARNs to exclude those vaults' contents from restore eligibility. Or, you can include a list of selectors. If this parameter and its value are not included, it defaults to empty list.
         */
        public var recoveryPointSelection: aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection? = null
        /**
         * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
         */
        public var restoreTestingPlanName: kotlin.String? = null
        /**
         * A CRON expression in specified timezone when a restore testing plan is executed. When no CRON expression is provided, Backup will use the default expression `cron(0 5 ? * * *)`.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         */
        public var scheduleExpressionTimezone: kotlin.String? = null
        /**
         * Defaults to 24 hours.
         *
         * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
         */
        public var startWindowHours: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForCreate) : this() {
            this.recoveryPointSelection = x.recoveryPointSelection
            this.restoreTestingPlanName = x.restoreTestingPlanName
            this.scheduleExpression = x.scheduleExpression
            this.scheduleExpressionTimezone = x.scheduleExpressionTimezone
            this.startWindowHours = x.startWindowHours
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForCreate = RestoreTestingPlanForCreate(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection] inside the given [block]
         */
        public fun recoveryPointSelection(block: aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection.Builder.() -> kotlin.Unit) {
            this.recoveryPointSelection = aws.sdk.kotlin.services.backup.model.RestoreTestingRecoveryPointSelection.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (restoreTestingPlanName == null) restoreTestingPlanName = ""
            if (scheduleExpression == null) scheduleExpression = ""
            return this
        }
    }
}
